<?php

use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\CreditCardController;
use App\Http\Controllers\ShopifyComparePriceController;
use App\Http\Controllers\ShopifyController;
use App\Http\Controllers\ShopifySalePriceController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ProviderController;
use App\Http\Controllers\ProviderBillController;
use App\Http\Controllers\BillImageController;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Rutas de autenticación
Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Rutas protegidas por autenticación
Route::middleware(['auth'])->group(function () {

    // Rutas principales - redirigen a órdenes
    Route::get('/', function () {
        return redirect()->route('orders.index');
    })->name('index');

    Route::get('/home', function () {
        return redirect()->route('orders.index');
    })->name('home');

    // Ruta principal de órdenes
    Route::get('/orders', [OrderController::class, 'index'])->name('orders');

    // Ruta de reportes
    Route::get('/reports', [ReportController::class, 'index'])->name('reports');

    // Rutas de Shopify y otros servicios
    Route::get('/contracts', [CreditCardController::class, 'listContracts'])->name('contracts');
    Route::get('/price', [ShopifyController::class, 'listProducts'])->name('products');
    Route::get('/price-sale', [ShopifySalePriceController::class, 'listProducts'])->name('sale_price');
    Route::get('/price-compare', [ShopifyComparePriceController::class, 'listProducts'])->name('compare_price');
    Route::post('/variant', [ShopifyController::class, 'listVariants'])->name('variants');
    Route::post('/update/variant', [ShopifyController::class, 'updateVariants'])->name('updateVariants');
    Route::post('/update/collection/sale_price', [ShopifySalePriceController::class, 'updatePrice'])->name('updateSalePrice');
    Route::post('/update/collection/reference_price', [ShopifyComparePriceController::class, 'updatePrice'])->name('updateReferencePrice');
    Route::post('/ccaf/sendContract/{id}', [CreditCardController::class, 'sendContract'])->name('sendContract');
    Route::get('/ccaf/contracts', [CreditCardController::class, 'getContracts']);

    // Rutas de recursos (CRUD)
    Route::get('/clients/search', [ClientController::class, 'search'])->name('clients.search');
    Route::resource('clients', ClientController::class);
    Route::resource('orders', OrderController::class);

    // Rutas adicionales para SoftDeletes
    Route::post('orders/{id}/restore', [OrderController::class, 'restore'])->name('orders.restore');
    Route::delete('orders/{id}/force-delete', [OrderController::class, 'forceDelete'])->name('orders.force-delete');

    // Rutas de pagos
    Route::post('orders/{order}/payments', [App\Http\Controllers\PaymentController::class, 'store'])->name('payments.store');
    Route::put('orders/{order}/payments/{payment}', [App\Http\Controllers\PaymentController::class, 'update'])->name('payments.update');
    Route::delete('orders/{order}/payments/{payment}', [App\Http\Controllers\PaymentController::class, 'destroy'])->name('payments.destroy');

    // Ruta para eliminar imágenes de órdenes
    Route::delete('orders/{order}/images/{orderImage}', [OrderController::class, 'destroyImage'])->name('orders.images.destroy');

    // Provider Bills routes
    Route::resource('providers', ProviderController::class);
    Route::resource('provider-bills', ProviderBillController::class);

    // Rutas para imágenes de bills
    Route::post('provider-bills/{bill}/images', [BillImageController::class, 'store'])->name('bill.images.store');
    Route::delete('provider-bills/{bill}/images/{billImage}', [BillImageController::class, 'destroy'])->name('bill.images.destroy');
    Route::put('bill-images/{billImage}', [BillImageController::class, 'update'])->name('bill.images.update');
    Route::get('provider-bills/{bill}/images', [BillImageController::class, 'index'])->name('bill.images.index');
});
