@extends('layouts.app')

@section('title', 'Deals of the Day')

@section('content')
<h1>Deals of the Day</h1>

<div class="deals-toolbar" style="margin-bottom:1.5rem;">
    <label for="search">Search products by title (Shopify)</label>
    <div style="display:flex; flex-wrap:wrap; gap:0.5rem; align-items:center; margin-top:0.25rem;">
        <input type="text" id="search" placeholder="Product title..." style="flex:1; min-width:200px; padding:0.5rem 0.75rem; border:1px solid #d1d5db; border-radius:6px;">
        <button type="button" id="btnSearch" class="btn btn-primary">Search</button>
    </div>
</div>

<div id="searchResults" style="margin-bottom:1.5rem; display:none;">
    <h2 style="font-size:1.1rem;">Search results</h2>
    <p id="searchStatus" style="font-size:0.9rem; color:#6b7280;"></p>
    <ul id="resultList" style="list-style:none; padding:0; max-height:300px; overflow-y:auto; border:1px solid #e5e7eb; border-radius:6px; padding:0.5rem;"></ul>
</div>

<div id="selectedSection" style="margin-bottom:1.5rem; display:none;">
    <h2 style="font-size:1.1rem;">Selected products</h2>
    <ul id="selectedList" style="list-style:none; padding:0;"></ul>
    <div style="display:flex; flex-wrap:wrap; gap:0.5rem; align-items:center; margin-top:0.5rem;">
        <label>Duration:</label>
        <input type="number" id="durationValue" min="1" value="24" style="width:80px; padding:0.4rem; border:1px solid #d1d5db; border-radius:6px;">
        <select id="durationUnit" style="padding:0.4rem; border:1px solid #d1d5db; border-radius:6px;">
            <option value="hours">Hours</option>
            <option value="days">Days</option>
        </select>
        <button type="button" id="btnApply" class="btn btn-primary">Apply deal (-$1) and set duration</button>
    </div>
    <p id="applyStatus" style="font-size:0.9rem; margin-top:0.5rem;"></p>
</div>

<hr style="margin:1.5rem 0;">
<h2 style="font-size:1.1rem;">Recent deals</h2>
@if($deals->isEmpty())
    <p>No deals yet.</p>
@else
    <ul style="list-style:none; padding:0;">
        @foreach($deals as $deal)
            <li style="border:1px solid #e5e7eb; border-radius:6px; padding:0.75rem; margin-bottom:0.5rem;">
                <strong>Deal #{{ $deal->id }}</strong> — {{ $deal->duration_value }} {{ $deal->duration_unit }}
                | Starts: {{ $deal->starts_at?->format('Y-m-d H:i') }}
                | Ends: {{ $deal->ends_at?->format('Y-m-d H:i') }}
                | {{ $deal->dealProducts->count() }} product(s)
                @if($deal->restored) <span style="color:green;">Restored</span> @endif
            </li>
        @endforeach
    </ul>
    {{ $deals->links('vendor.pagination.simple-default') }}
@endif

@push('scripts')
<script>
(function() {
    const csrf = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    const selected = [];

    function showSelected() {
        const section = document.getElementById('selectedSection');
        const list = document.getElementById('selectedList');
        if (selected.length === 0) {
            section.style.display = 'none';
            return;
        }
        section.style.display = 'block';
        list.innerHTML = selected.map((item, i) =>
            '<li style="padding:0.35rem 0; border-bottom:1px solid #eee;">' +
            item.title + ' — $' + item.price + ' <button type="button" data-idx="' + i + '" class="btn-remove btn btn-secondary" style="padding:0.2rem 0.5rem; font-size:0.8rem;">Remove</button></li>'
        ).join('');
        list.querySelectorAll('.btn-remove').forEach(btn => {
            btn.addEventListener('click', () => {
                selected.splice(parseInt(btn.dataset.idx, 10), 1);
                showSelected();
            });
        });
    }

    document.getElementById('btnSearch').addEventListener('click', function() {
        const q = document.getElementById('search').value.trim();
        const block = document.getElementById('searchResults');
        const status = document.getElementById('searchStatus');
        const ul = document.getElementById('resultList');
        block.style.display = 'block';
        status.textContent = 'Searching...';
        ul.innerHTML = '';

        fetch('{{ route("deals.search") }}?q=' + encodeURIComponent(q), {
            headers: { 'X-Requested-With': 'XMLHttpRequest', 'Accept': 'application/json' }
        })
            .then(r => r.json())
            .then(data => {
                if (data.error) { status.textContent = data.error; return; }
                const products = data.products || [];
                status.textContent = products.length + ' variant(s) found.';
                products.forEach(p => {
                    const li = document.createElement('li');
                    li.style.padding = '0.35rem 0';
                    li.style.borderBottom = '1px solid #eee';
                    li.innerHTML = p.title + ' — $' + p.price +
                        ' <button type="button" class="btn-add btn btn-primary" style="padding:0.2rem 0.5rem; font-size:0.8rem;">Add</button>';
                    li.querySelector('.btn-add').addEventListener('click', () => {
                        selected.push({
                            variant_id: p.variant_id,
                            product_id: p.product_id || null,
                            title: p.title,
                            price: p.price,
                            compare_at_price: p.compare_at_price || null
                        });
                        showSelected();
                    });
                    ul.appendChild(li);
                });
            })
            .catch(e => { status.textContent = 'Error: ' + e.message; });
    });

    document.getElementById('btnApply').addEventListener('click', function() {
        if (selected.length === 0) {
            document.getElementById('applyStatus').textContent = 'Select at least one product.';
            return;
        }
        const value = parseInt(document.getElementById('durationValue').value, 10) || 1;
        const unit = document.getElementById('durationUnit').value;
        const status = document.getElementById('applyStatus');
        status.textContent = 'Applying...';

        fetch('{{ route("deals.apply") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': csrf,
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            },
            body: JSON.stringify({
                items: selected,
                duration_value: value,
                duration_unit: unit
            })
        })
            .then(r => r.json())
            .then(data => {
                status.textContent = data.message || (data.success ? 'Done.' : 'Error');
                if (data.success) {
                    selected.length = 0;
                    showSelected();
                    window.location.reload();
                }
            })
            .catch(e => { status.textContent = 'Error: ' + e.message; });
    });
})();
</script>
@endpush
@endsection
