<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Deals of the Day')</title>
    <style>
        *, *::before, *::after { box-sizing: border-box; }
        body { margin: 0; font-family: system-ui, -apple-system, sans-serif; font-size: 1rem; line-height: 1.5; color: #1a1a1a; background: #f5f5f5; }
        .container { width: 100%; max-width: 1200px; margin: 0 auto; padding: 0 1rem; }
        .header { background: #222; color: #fff; padding: 0.75rem 0; }
        .header .container { display: flex; flex-wrap: wrap; align-items: center; justify-content: space-between; gap: 0.5rem; }
        .header a { color: #fff; text-decoration: none; padding: 0.25rem 0.5rem; border-radius: 4px; }
        .header a:hover { background: rgba(255,255,255,0.15); }
        .nav { display: flex; flex-wrap: wrap; gap: 0.25rem; }
        .main { padding: 1.5rem 0; min-height: 60vh; }
        .btn { display: inline-block; padding: 0.5rem 1rem; border: none; border-radius: 6px; cursor: pointer; font-size: 0.95rem; text-decoration: none; }
        .btn-primary { background: #2563eb; color: #fff; }
        .btn-primary:hover { background: #1d4ed8; }
        .btn-secondary { background: #6b7280; color: #fff; }
        .btn-danger { background: #dc2626; color: #fff; }
        .alert { padding: 0.75rem 1rem; border-radius: 6px; margin-bottom: 1rem; }
        .alert-success { background: #d1fae5; color: #0f766e; }
        .alert-error { background: #fee2e2; color: #b91c1c; }
        @media (max-width: 640px) {
            .header .container { flex-direction: column; align-items: flex-start; }
        }
    </style>
    @stack('styles')
</head>
<body>
    <header class="header">
        <div class="container">
            <a href="{{ route('home') }}">Deals of the Day</a>
            <nav class="nav">
                <a href="{{ route('home') }}">Home</a>
                <a href="{{ route('deals.index') }}">Deals of the Day</a>
                <form action="{{ route('logout') }}" method="POST" style="display:inline;">
                    @csrf
                    <button type="submit" class="btn btn-secondary" style="padding:0.25rem 0.5rem; font-size:0.9rem;">Logout</button>
                </form>
            </nav>
        </div>
    </header>
    <main class="main">
        <div class="container">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="alert alert-error">{{ session('error') }}</div>
            @endif
            @yield('content')
        </div>
    </main>
    @stack('scripts')
</body>
</html>
