<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('deal_products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('deal_id')->constrained()->cascadeOnDelete();
            $table->string('shopify_product_id')->nullable();   // Shopify GID
            $table->string('shopify_variant_id');                // Shopify variant GID
            $table->string('title')->nullable();
            $table->decimal('original_price', 15, 2);            // sale price before deal
            $table->decimal('original_compare_at_price', 15, 2)->nullable(); // compare-at before deal
            $table->decimal('deal_price', 15, 2);                // sale price during deal
            $table->decimal('deal_compare_at_price', 15, 2)->nullable(); // compare-at during deal
            $table->boolean('restored')->default(false);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('deal_products');
    }
};
