<?php

use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\DealsController;
use App\Http\Controllers\HomeController;
use Illuminate\Support\Facades\Route;

Route::get('login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('login', [LoginController::class, 'login']);
Route::post('logout', [LoginController::class, 'logout'])->name('logout');

Route::middleware('auth')->group(function () {
    Route::get('/', [HomeController::class, 'index'])->name('home');
    Route::get('/deals', [DealsController::class, 'index'])->name('deals.index');
    Route::get('/deals/search', [DealsController::class, 'search'])->name('deals.search');
    Route::post('/deals/apply', [DealsController::class, 'apply'])->name('deals.apply');
    Route::get('/deals/{deal}/edit', [DealsController::class, 'edit'])->name('deals.edit');
    Route::put('/deals/{deal}', [DealsController::class, 'update'])->name('deals.update');
    Route::delete('/deals/{deal}', [DealsController::class, 'destroy'])->name('deals.destroy');
});
