@extends('layouts.app')

@section('title', 'Edit deal #' . $deal->id)

@section('content')
<h1>Edit deal #{{ $deal->id }}</h1>

<p style="margin-bottom:1rem;">{{ $deal->dealProducts->count() }} product(s). Change when the deal should end (prices will restore at that time).</p>

<form method="post" action="{{ route('deals.update', $deal) }}" style="max-width:400px;">
    @csrf
    @method('PUT')
    <div style="margin-bottom:1rem;">
        <label for="ends_at" style="display:block; font-size:0.9rem; margin-bottom:0.25rem;">End date & time</label>
        <input type="datetime-local" id="ends_at" name="ends_at" value="{{ $deal->ends_at?->format('Y-m-d\TH:i') }}"
               required step="60" style="width:100%; padding:0.5rem; border:1px solid #d1d5db; border-radius:6px;">
        @error('ends_at')
            <span style="color:#dc2626; font-size:0.85rem;">{{ $message }}</span>
        @enderror
    </div>
    <div style="display:flex; gap:0.5rem;">
        <button type="submit" class="btn btn-primary">Save</button>
        <a href="{{ route('deals.index') }}" class="btn btn-secondary">Cancel</a>
    </div>
</form>
@endsection
