<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DealProduct extends Model
{
    use HasFactory;

    protected $fillable = [
        'deal_id',
        'shopify_product_id',
        'shopify_variant_id',
        'title',
        'image_url',
        'cost',
        'original_price',
        'original_compare_at_price',
        'deal_price',
        'deal_compare_at_price',
        'restored',
    ];

    protected $casts = [
        'cost' => 'decimal:2',
        'original_price' => 'decimal:2',
        'original_compare_at_price' => 'decimal:2',
        'deal_price' => 'decimal:2',
        'deal_compare_at_price' => 'decimal:2',
        'restored' => 'boolean',
    ];

    public function deal(): BelongsTo
    {
        return $this->belongsTo(Deal::class);
    }
}
