<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('deals', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('duration_value');      // number (e.g. 24)
            $table->enum('duration_unit', ['hours', 'days']); // hours or days
            $table->timestamp('starts_at')->nullable();    // when deal was applied
            $table->timestamp('ends_at')->nullable();      // when to restore prices
            $table->boolean('restored')->default(false);   // true after prices restored
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('deals');
    }
};
