<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Deal extends Model
{
    use HasFactory;

    protected $fillable = [
        'duration_value',
        'duration_unit',
        'starts_at',
        'ends_at',
        'restored',
        'profit_type',
        'profit_value',
        'compare_discount_percent',
    ];

    protected $casts = [
        'starts_at' => 'datetime',
        'ends_at' => 'datetime',
        'restored' => 'boolean',
        'profit_value' => 'decimal:2',
        'compare_discount_percent' => 'decimal:2',
    ];

    public function dealProducts(): HasMany
    {
        return $this->hasMany(DealProduct::class);
    }
}
