<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('deals', function (Blueprint $table) {
            $table->string('profit_type', 20)->nullable()->after('restored');
            $table->decimal('profit_value', 15, 2)->nullable()->after('profit_type');
            $table->decimal('compare_discount_percent', 5, 2)->nullable()->after('profit_value');
        });
        Schema::table('deal_products', function (Blueprint $table) {
            $table->string('image_url', 500)->nullable()->after('title');
        });
    }

    public function down(): void
    {
        Schema::table('deals', function (Blueprint $table) {
            $table->dropColumn(['profit_type', 'profit_value', 'compare_discount_percent']);
        });
        Schema::table('deal_products', function (Blueprint $table) {
            $table->dropColumn('image_url');
        });
    }
};
