# Deals of the Day (Laravel v1)

Admin to manage Shopify "Deals of the Day": search products by title, select them, save original prices in DB, apply a price rule (-$1 in v1), and set deal duration (hours or days). Prices are restored automatically when the deal ends.

## Setup

1. **Create the database** in phpMyAdmin (same MySQL user/password as your other project):
   - Create database: `admin_shopify_deals`
   - Import: `database/admin_shopify_deals.sql`

2. **Install dependencies** (on a machine with PHP and Composer):
   ```bash
   cd admin-shopify-deals
   composer install
   ```

3. **Configure environment**:
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```
   Edit `.env`:
   - `DB_DATABASE=admin_shopify_deals`
   - `DB_USERNAME` and `DB_PASSWORD` = same as your other project
   - `SHOPIFY_SHOP`, `SHOPIFY_CLIENT_ID`, `SHOPIFY_CLIENT_SECRET` (from your Shopify app / reference file)
   - `SHOPIFY_API_VERSION=2024-01` (or 2026-01 as in reference)

4. **Create a user** (for login):
   ```bash
   php artisan tinker
   >>> \App\Models\User::create(['name'=>'Admin','email'=>'admin@example.com','password'=>bcrypt('password')]);
   ```

5. **Run migrations** (optional if you imported the SQL):
   ```bash
   php artisan migrate
   ```

6. **Scheduler** (to restore prices when deals expire): add to server crontab:
   ```bash
   * * * * * cd /path/to/admin-shopify-deals && php artisan schedule:run >> /dev/null 2>&1
   ```
   Or run manually: `php artisan deals:restore-expired`

## Usage

- Log in with the user you created.
- Menu: **Home**, **Deals of the Day**, **Logout**.
- In **Deals of the Day**: search by title, add products one by one, set duration (number + hours/days), click **Apply deal (-$1) and set duration**. Original prices are saved in the DB and applied again when the deal ends.

## Reference

- Shopify API connection follows the same approach as `productos-costo-cero(1).php` (OAuth client_credentials + GraphQL).
