# to-absolute-glob [![NPM version](https://badge.fury.io/js/to-absolute-glob.svg)](http://badge.fury.io/js/to-absolute-glob)

> Make a glob pattern absolute, ensuring that negative globs and patterns with trailing slashes are correctly handled.

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i to-absolute-glob --save
```

## Usage

```js
var toAbsGlob = require('to-absolute-glob');
toAbsGlob('a/*.js');
//=> '/dev/foo/a/*.js'
```

## Examples

Given the current project folder (cwd) is `/dev/foo/`:

**makes a path absolute**

```js
toAbsGlob('a');
//=> '/dev/foo/a'
```

**makes a glob absolute**

```js
toAbsGlob('a/*.js');
//=> '/dev/foo/a/*.js'
```

**retains trailing slashes**

```js
toAbsGlob('a/*/');
//=> '/dev/foo/a/*/'
```

**retains trailing slashes with cwd**

```js
toAbsGlob('./fixtures/whatsgoingon/*/', {cwd: __dirname});
//=> '/dev/foo/'
```

**makes a negative glob absolute**

```js
toAbsGlob('!a/*.js');
//=> '!/dev/foo/a/*.js'
```

**from a cwd**

```js
toAbsGlob('a/*.js', {cwd: 'foo'});
//=> '/dev/foo/foo/a/*.js'
```

**makes a negative glob absolute from a cwd**

```js
toAbsGlob('!a/*.js', {cwd: 'foo'});
//=> '!/dev/foo/foo/a/*.js'
```

**from a root path**

```js
toAbsGlob('/a/*.js', {root: 'baz'});
//=> '/dev/foo/baz/a/*.js'
```

**from a root slash**

```js
toAbsGlob('/a/*.js', {root: '/'});
//=> '/dev/foo/a/*.js'
```

**from a negative root path**

```js
toAbsGlob('!/a/*.js', {root: 'baz'});
//=> '!/dev/foo/baz/a/*.js'
```

**from a negative root slash**

```js
toAbsGlob('!/a/*.js', {root: '/'});
//=> '!/dev/foo/a/*.js'
```

## Related projects

* [has-glob](https://www.npmjs.com/package/has-glob): Returns `true` if an array has a glob pattern. | [homepage](https://github.com/jonschlinkert/has-glob)
* [is-glob](https://www.npmjs.com/package/is-glob): Returns `true` if the given string looks like a glob pattern or an extglob pattern.… [more](https://www.npmjs.com/package/is-glob) | [homepage](https://github.com/jonschlinkert/is-glob)
* [is-valid-glob](https://www.npmjs.com/package/is-valid-glob): Return true if a value is a valid glob pattern or patterns. | [homepage](https://github.com/jonschlinkert/is-valid-glob)

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](/new).

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on November 05, 2015._