<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Font;

class FontMigrationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $fontsFromConfig = config('app.font_collection');

        foreach ($fontsFromConfig as $fontData) {
            // Check if font already exists
            $existingFont = Font::where('font_name', $fontData['font'])->first();

            if (!$existingFont) {
                Font::create([
                    'font_name' => $fontData['font'],
                    'display_name' => $fontData['name'],
                    'file_name' => $fontData['name'],
                    'file_path' => $fontData['name'] . '.ttf', // Assume .ttf extension
                    'style' => $fontData['style'],
                    'gender' => $fontData['gender'],
                    'font_size' => (int) str_replace('vw', '', explode('font-size: ', $fontData['style'])[1] ?? '18'),
                    'top_position' => (int) str_replace('px', '', explode('top: ', $fontData['style'])[1] ?? '50'),
                    'review_rating' => (int) $fontData['review'],
                    'is_active' => true
                ]);

                $this->command->info("Migrated font: {$fontData['name']}");
            } else {
                $this->command->info("Font already exists: {$fontData['name']}");
            }
        }

        $this->command->info('Font migration completed!');
    }
}
