<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Actualización de Precio de Oro</title>
    <!--[if mso]>
    <style type="text/css">
        body, table, td {font-family: Arial, sans-serif !important;}
        .mso-table {border-collapse: collapse !important;}
    </style>
    <![endif]-->
</head>

<body
    style="margin: 0; padding: 0; background-color: #f5f7fa; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;">
    <!-- Wrapper Table -->
    <table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0"
        style="background-color: #f5f7fa;">
        <tr>
            <td align="center" style="padding: 40px 15px;">
                <!-- Main Container -->
                <table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0"
                    style="max-width: 600px; background-color: #ffffff; border-radius: 16px; box-shadow: 0 4px 20px rgba(0,0,0,0.08); overflow: hidden;">

                    <!-- Header -->
                    <tr>
                        <td
                            style="background: linear-gradient(135deg, #FFD700 0%, #FFA500 100%); padding: 50px 30px; text-align: center;">
                            <h1
                                style="margin: 0 0 10px 0; color: #000000; font-size: 32px; font-weight: 700; letter-spacing: -0.5px;">
                                Gold Price Updated</h1>
                            <p
                                style="margin: 0; color: #000000; font-size: 14px; font-weight: 400; text-transform: uppercase; letter-spacing: 1px;">
                                <?php echo e(ucfirst($executionType)); ?> Update Complete</p>
                        </td>
                    </tr>

                    <!-- Body -->
                    <tr>
                        <td style="padding: 40px 30px;">

                            <!-- Date -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0">
                                <tr>
                                    <td align="center" style="padding-bottom: 30px;">
                                        <span
                                            style="display: inline-block; padding: 8px 20px; background-color: #f8f9fa; color: #6c757d; border-radius: 20px; font-size: 13px; font-weight: 500;">
                                            <?php echo e(now()->format('F j, Y')); ?> • <?php echo e(now()->format('g:i A T')); ?>

                                        </span>
                                    </td>
                                </tr>
                            </table>

                            <!-- Gold Price Card -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0">
                                <tr>
                                    <td
                                        style="background-color: #f8f9fa; border-radius: 12px; padding: 30px; text-align: center; margin-bottom: 30px;">
                                        <p
                                            style="margin: 0 0 10px 0; color: #6c757d; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px;">
                                            Current Gold Price</p>
                                        <h2
                                            style="margin: 0; color: #FFD700; font-size: 56px; font-weight: 800; line-height: 1;">
                                            $<?php echo e(number_format($goldPrice, 2)); ?></h2>
                                        <p style="margin: 10px 0 0 0; color: #868e96; font-size: 14px;">per troy ounce
                                        </p>
                                    </td>
                                </tr>
                            </table>

                            <?php if(count($collections) > 0): ?>
                                <!-- Collections Section -->
                                <h2
                                    style="margin: 0 0 25px 0; color: #212529; font-size: 22px; font-weight: 700; padding-bottom: 12px; border-bottom: 3px solid #FFD700;">
                                    Update Summary</h2>

                                <?php $__currentLoopData = $collections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $collection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <!-- Collection Card -->
                                    <table role="presentation" width="100%" cellpadding="0" cellspacing="0"
                                        border="0"
                                        style="margin-bottom: 24px; border: 2px solid #e9ecef; border-radius: 12px; overflow: hidden;">

                                        <!-- Collection Header -->
                                        <tr>
                                            <td
                                                style="background-color: #f8f9fa; padding: 20px; border-bottom: 2px solid #e9ecef;">
                                                <table role="presentation" width="100%" cellpadding="0"
                                                    cellspacing="0" border="0">
                                                    <tr>
                                                        <td>
                                                            <h3
                                                                style="margin: 0; color: #212529; font-size: 18px; font-weight: 700;">
                                                                <?php echo e($collection['name']); ?></h3>
                                                        </td>
                                                        <td align="right">
                                                            <?php if($collection['has_errors']): ?>
                                                                <span
                                                                    style="display: inline-block; padding: 6px 14px; background-color: #fff3cd; color: #856404; border-radius: 20px; font-size: 12px; font-weight: 600;">Errors</span>
                                                            <?php else: ?>
                                                                <span
                                                                    style="display: inline-block; padding: 6px 14px; background-color: #d4edda; color: #155724; border-radius: 20px; font-size: 12px; font-weight: 600;">Success</span>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>

                                        <!-- Collection Body -->
                                        <tr>
                                            <td style="padding: 20px;">

                                                <!-- Products Processed -->
                                                <table role="presentation" width="100%" cellpadding="0"
                                                    cellspacing="0" border="0" style="margin-bottom: 20px;">
                                                    <tr>
                                                        <td
                                                            style="background-color: #f8f9fa; padding: 16px; border-radius: 8px;">
                                                            <table role="presentation" width="100%" cellpadding="0"
                                                                cellspacing="0" border="0">
                                                                <tr>
                                                                    <td
                                                                        style="color: #6c757d; font-size: 14px; font-weight: 500;">
                                                                        Products Processed:</td>
                                                                    <td align="right"
                                                                        style="color: #212529; font-size: 24px; font-weight: 700;">
                                                                        <?php echo e($collection['products_processed']); ?></td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>

                                                <?php if($collection['price_10k']): ?>
                                                    <!-- 10K Card -->
                                                    <table role="presentation" width="100%" cellpadding="0"
                                                        cellspacing="0" border="0" style="margin-bottom: 16px;">
                                                        <tr>
                                                            <td
                                                                style="background: linear-gradient(135deg, #FFF9E6 0%, #FFE082 100%); border-left: 5px solid #FFC107; padding: 20px; border-radius: 10px;">
                                                                <h4
                                                                    style="margin: 0 0 12px 0; color: #856404; font-size: 15px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px;">
                                                                    10K Gold</h4>
                                                                <table role="presentation" width="100%"
                                                                    cellpadding="0" cellspacing="0" border="0">
                                                                    <tr>
                                                                        <td
                                                                            style="padding-bottom: 8px; color: #856404; font-size: 13px; font-weight: 500;">
                                                                            Price: <span
                                                                                style="color: #212529; font-size: 20px; font-weight: 700;">$<?php echo e(number_format($collection['price_10k'], 2)); ?></span>
                                                                            <span
                                                                                style="color: #856404; font-size: 12px;">/gr</span>
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td
                                                                            style="color: #856404; font-size: 13px; font-weight: 500;">
                                                                            Updated: <span
                                                                                style="color: #212529; font-size: 18px; font-weight: 600;"><?php echo e($collection['products_updated_10k']); ?>

                                                                                products</span>
                                                                        </td>
                                                                    </tr>
                                                                    <?php if($collection['errors_10k'] > 0): ?>
                                                                        <tr>
                                                                            <td
                                                                                style="padding-top: 8px; color: #dc3545; font-size: 13px; font-weight: 600;">
                                                                                <?php echo e($collection['errors_10k']); ?> error(s)
                                                                            </td>
                                                                        </tr>
                                                                    <?php endif; ?>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                <?php endif; ?>

                                                <?php if($collection['price_14k']): ?>
                                                    <!-- 14K Card -->
                                                    <table role="presentation" width="100%" cellpadding="0"
                                                        cellspacing="0" border="0" style="margin-bottom: 16px;">
                                                        <tr>
                                                            <td
                                                                style="background: linear-gradient(135deg, #FFF3E0 0%, #FFB74D 100%); border-left: 5px solid #FF9800; padding: 20px; border-radius: 10px;">
                                                                <h4
                                                                    style="margin: 0 0 12px 0; color: #E65100; font-size: 15px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px;">
                                                                    14K Gold</h4>
                                                                <table role="presentation" width="100%"
                                                                    cellpadding="0" cellspacing="0" border="0">
                                                                    <tr>
                                                                        <td
                                                                            style="padding-bottom: 8px; color: #E65100; font-size: 13px; font-weight: 500;">
                                                                            Price: <span
                                                                                style="color: #212529; font-size: 20px; font-weight: 700;">$<?php echo e(number_format($collection['price_14k'], 2)); ?></span>
                                                                            <span
                                                                                style="color: #E65100; font-size: 12px;">/gr</span>
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td
                                                                            style="color: #E65100; font-size: 13px; font-weight: 500;">
                                                                            Updated: <span
                                                                                style="color: #212529; font-size: 18px; font-weight: 600;"><?php echo e($collection['products_updated_14k']); ?>

                                                                                products</span>
                                                                        </td>
                                                                    </tr>
                                                                    <?php if($collection['errors_14k'] > 0): ?>
                                                                        <tr>
                                                                            <td
                                                                                style="padding-top: 8px; color: #dc3545; font-size: 13px; font-weight: 600;">
                                                                                <?php echo e($collection['errors_14k']); ?>

                                                                                error(s)
                                                                            </td>
                                                                        </tr>
                                                                    <?php endif; ?>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                <?php endif; ?>

                                            </td>
                                        </tr>
                                    </table>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <table role="presentation" width="100%" cellpadding="0" cellspacing="0"
                                    border="0">
                                    <tr>
                                        <td
                                            style="background-color: #f8f9fa; padding: 24px; border-radius: 8px; text-align: center;">
                                            <p style="margin: 0; color: #6c757d; font-size: 16px;">No collections were
                                                processed.</p>
                                        </td>
                                    </tr>
                                </table>
                            <?php endif; ?>

                            <!-- Divider -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0"
                                border="0" style="margin-top: 40px;">
                                <tr>
                                    <td style="border-top: 3px solid #e9ecef; padding: 30px 0;">
                                        <!-- Empty space -->
                                    </td>
                                </tr>
                            </table>

                            <!-- Footer -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0"
                                border="0">
                                <tr>
                                    <td style="text-align: center; padding-bottom: 20px;">
                                        <p
                                            style="margin: 0 0 8px 0; color: #868e96; font-size: 15px; font-weight: 400;">
                                            Thank you for using our automated gold price management system
                                        </p>
                                        <p style="margin: 0; color: #adb5bd; font-size: 13px;">
                                            <?php echo e(config('app.name')); ?> • <?php echo e(now()->year); ?></p>
                                    </td>
                                </tr>
                            </table>

                        </td>
                    </tr>

                    <!-- Footer Banner -->
                    <tr>
                        <td
                            style="background-color: #f8f9fa; padding: 20px 30px; text-align: center; border-top: 3px solid #FFD700;">
                            <p style="margin: 0; color: #868e96; font-size: 12px; line-height: 1.6;">
                                This is an automated notification • Please do not reply to this email
                            </p>
                        </td>
                    </tr>

                </table>
            </td>
        </tr>
    </table>
</body>

</html>
<?php /**PATH /home/avijewels/public_html/admin.shopify.avijewels.info/resources/views/emails/gold-price-update.blade.php ENDPATH**/ ?>