<?php

use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\CreditCardController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\GoldPriceLogsController;
use App\Http\Controllers\ShopifyComparePriceController;
use App\Http\Controllers\ShopifyController;
use App\Http\Controllers\ShopifySalePriceController;
use App\Http\Controllers\ShopifyCostPriceController;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::middleware('auth')->group(function () {
    Route::get('/', function () {
        return Inertia::render('new-index'); // Aquí 'Home' es el nombre de la vista Vue
        // return redirect()->route('new-index');
    })->name('index');

    Route::get('/home', function () {
        return Inertia::render('new-index'); // Nombre del componente Vue
        // return redirect()->route('new-index');
    })->name('home');

    // Rutas de clientes
    Route::get('/customers', [CustomerController::class, 'index'])->name('customers.index');
    Route::get('/customers/create', [CustomerController::class, 'create'])->name('customers.create');
    Route::post('/customers', [CustomerController::class, 'store'])->name('customers.store');
    Route::get('/customers/{customer}/edit', [CustomerController::class, 'edit'])->name('customers.edit');
    Route::put('/customers/{customer}', [CustomerController::class, 'update'])->name('customers.update');
    Route::delete('/customers/{customer}', [CustomerController::class, 'destroy'])->name('customers.destroy');

    Route::get('/contracts', [CreditCardController::class, 'listContracts'])->name('contracts');
    Route::get('/price', [ShopifyController::class, 'listProducts'])->name('products');
    Route::post('/get/material/data', [ShopifyController::class, 'getMaterialData'])->name('getMaterialData');
    Route::get('/price-sale', [ShopifySalePriceController::class, 'listProducts'])->name('sale_price');
    Route::get('/price-compare', [ShopifyComparePriceController::class, 'listProducts'])->name('compare_price');
    Route::get('/price-cost', [ShopifyCostPriceController::class, 'listProducts'])->name('cost_price');

    Route::post('/update/collection/front-gold/sale-price', [ShopifySalePriceController::class, 'updatePriceFrontGold'])->name('updateSalePrice');
    Route::post('/update/variant', [ShopifyController::class, 'updateVariants'])->name('updateVariants');
    Route::post('/update/collection/sale_price', [ShopifySalePriceController::class, 'updatePrice'])->name('updateSalePrice');
    Route::post('/update/collection/cost_price', [ShopifyCostPriceController::class, 'updatePrice'])->name('updateCostPrice');
    Route::get('/get/collection/cost_configuration', [ShopifyCostPriceController::class, 'getConfiguration'])->name('getCostConfiguration');
    Route::get('/get/collection/cost_price_logs', [ShopifyCostPriceController::class, 'getLatestLogs'])->name('getCostPriceLogs');
    Route::get('/get/collection/cost_price_progress', [ShopifyCostPriceController::class, 'getProgress'])->name('getCostPriceProgress');
    Route::get('/get/collection/sale_price_progress', [ShopifySalePriceController::class, 'getProgress'])->name('getSalePriceProgress');
    Route::get('/get/collection/products', [ShopifyCostPriceController::class, 'getCollectionProducts'])->name('getCollectionProducts');
    Route::get('/get/collection/compare_products', [ShopifyComparePriceController::class, 'getCollectionProducts'])->name('getCompareProducts');
    Route::get('/get/collection/sale_products', [ShopifySalePriceController::class, 'getCollectionProducts'])->name('getSaleProducts');
    Route::post('/update/collection/reference_price', [ShopifyComparePriceController::class, 'updatePrice'])->name('updateReferencePrice');
    Route::post('/update/collection/reference_price_from_sale', [ShopifyComparePriceController::class, 'updatePriceFromSale'])->name('updateReferencePriceFromSale');
    Route::post('/ccaf/sendContract/{id}', [CreditCardController::class, 'sendContract'])->name('sendContract');
    Route::get('/ccaf/contracts', [CreditCardController::class, 'getContracts']);
    Route::get('/configuration', [App\Http\Controllers\ConfigurationController::class, 'index'])->name('configuration.index');
    Route::put('/configuration', [App\Http\Controllers\ConfigurationController::class, 'update'])->name('configuration.update');

    // Weight Rules routes
    Route::get('/configuration/weight-rules', [App\Http\Controllers\ConfigurationController::class, 'getWeightRules'])->name('configuration.weight-rules.index');
    Route::post('/configuration/weight-rules', [App\Http\Controllers\ConfigurationController::class, 'storeWeightRule'])->name('configuration.weight-rules.store');
    Route::put('/configuration/weight-rules/{id}', [App\Http\Controllers\ConfigurationController::class, 'updateWeightRule'])->name('configuration.weight-rules.update');
    Route::delete('/configuration/weight-rules/{id}', [App\Http\Controllers\ConfigurationController::class, 'deleteWeightRule'])->name('configuration.weight-rules.delete');

    // Gold Price Logs routes
    Route::get('/gold-price-logs', [GoldPriceLogsController::class, 'index'])->name('gold-price-logs.index');
    Route::get('/gold-price-logs/latest', [GoldPriceLogsController::class, 'latest'])->name('gold-price-logs.latest');
    Route::get('/gold-price-logs/{id}', [GoldPriceLogsController::class, 'show'])->name('gold-price-logs.show');
});

Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
