import { createApp, h } from "vue";
import { createInertiaApp } from "@inertiajs/vue3";
import { resolvePageComponent } from "laravel-vite-plugin/inertia-helpers";
import { createPinia } from "pinia";
import { createHead } from "@vueuse/head";
import { PerfectScrollbarPlugin } from "vue3-perfect-scrollbar";
import { TippyPlugin } from "tippy.vue";
import { vMaska } from "maska/vue";
import VueEasymde from "vue3-easymde";
import Popper from "vue3-popper";
import vue3JsonExcel from "vue3-json-excel";
import appSetting from "@/app-setting";
import i18n from "@/i18n";
import { Link } from "@inertiajs/vue3";

import "easymde/dist/easymde.min.css";
import "@/assets/css/app.css";
import DefaultLayout from "@/layouts/app-layout.vue"; 
import LoginLayout from "@/layouts/auth-layout.vue"; 
// Configuración de Inertia.js


createInertiaApp({
  resolve: (name) =>
    resolvePageComponent(`./Pages/${name}.vue`, import.meta.glob("./**/*.vue")).then((page) => {
      // Asigna el layout predeterminado si no está definido en la página
      if (name.toLowerCase().includes("login")) {
        page.default.layout = LoginLayout; // Usar el layout de autenticación
      } else {
        page.default.layout = page.default.layout || DefaultLayout; // Usar el layout por defecto
      }
      return page;
    }),
  setup({ el, App, props, plugin }) {
    const app = createApp({ render: () => h(App, props) });

    // Integrar plugins
    const pinia = createPinia();
    const head = createHead();

    app.use(plugin);
    app.use(pinia);
    app.use(head);
    app.use(PerfectScrollbarPlugin);
    app.use(TippyPlugin);
    app.use(VueEasymde);
    app.use(vue3JsonExcel);

    // Directivas personalizadas
    app.directive("maska", vMaska);

    // Componentes globales
    app.component("Popper", Popper);

    // Inicializar configuraciones
    appSetting.init();

    // Configuración de i18n
    app.use(i18n);

    
    app.component("Link", Link);

    // Montar la aplicación
    app.mount(el);
  },
});
