import { toRefs, computed, toRaw, openBlock, createElementBlock, renderSlot, createTextVNode, toDisplayString } from "vue";
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
var download$1 = { exports: {} };
(function(module, exports) {
  (function(root, factory) {
    {
      module.exports = factory();
    }
  })(commonjsGlobal, function() {
    return function download2(data, strFileName, strMimeType) {
      var self2 = window, defaultMime = "application/octet-stream", mimeType = strMimeType || defaultMime, payload = data, url = !strFileName && !strMimeType && payload, anchor = document.createElement("a"), toString = function(a) {
        return String(a);
      }, myBlob = self2.Blob || self2.MozBlob || self2.WebKitBlob || toString, fileName = strFileName || "download", blob, reader;
      myBlob = myBlob.call ? myBlob.bind(self2) : Blob;
      if (String(this) === "true") {
        payload = [payload, mimeType];
        mimeType = payload[0];
        payload = payload[1];
      }
      if (url && url.length < 2048) {
        fileName = url.split("/").pop().split("?")[0];
        anchor.href = url;
        if (anchor.href.indexOf(url) !== -1) {
          var ajax = new XMLHttpRequest();
          ajax.open("GET", url, true);
          ajax.responseType = "blob";
          ajax.onload = function(e) {
            download2(e.target.response, fileName, defaultMime);
          };
          setTimeout(function() {
            ajax.send();
          }, 0);
          return ajax;
        }
      }
      if (/^data:([\w+-]+\/[\w+.-]+)?[,;]/.test(payload)) {
        if (payload.length > 1024 * 1024 * 1.999 && myBlob !== toString) {
          payload = dataUrlToBlob(payload);
          mimeType = payload.type || defaultMime;
        } else {
          return navigator.msSaveBlob ? navigator.msSaveBlob(dataUrlToBlob(payload), fileName) : saver(payload);
        }
      } else {
        if (/([\x80-\xff])/.test(payload)) {
          var i = 0, tempUiArr = new Uint8Array(payload.length), mx = tempUiArr.length;
          for (i; i < mx; ++i)
            tempUiArr[i] = payload.charCodeAt(i);
          payload = new myBlob([tempUiArr], { type: mimeType });
        }
      }
      blob = payload instanceof myBlob ? payload : new myBlob([payload], { type: mimeType });
      function dataUrlToBlob(strUrl) {
        var parts = strUrl.split(/[:;,]/), type = parts[1], decoder = parts[2] == "base64" ? atob : decodeURIComponent, binData = decoder(parts.pop()), mx2 = binData.length, i2 = 0, uiArr = new Uint8Array(mx2);
        for (i2; i2 < mx2; ++i2)
          uiArr[i2] = binData.charCodeAt(i2);
        return new myBlob([uiArr], { type });
      }
      function saver(url2, winMode) {
        if ("download" in anchor) {
          anchor.href = url2;
          anchor.setAttribute("download", fileName);
          anchor.className = "download-js-link";
          anchor.innerHTML = "downloading...";
          anchor.style.display = "none";
          document.body.appendChild(anchor);
          setTimeout(function() {
            anchor.click();
            document.body.removeChild(anchor);
            if (winMode === true) {
              setTimeout(function() {
                self2.URL.revokeObjectURL(anchor.href);
              }, 250);
            }
          }, 66);
          return true;
        }
        if (/(Version)\/(\d+)\.(\d+)(?:\.(\d+))?.*Safari\//.test(navigator.userAgent)) {
          if (/^data:/.test(url2))
            url2 = "data:" + url2.replace(/^data:([\w\/\-\+]+)/, defaultMime);
          if (!window.open(url2)) {
            if (confirm("Displaying New Document\n\nUse Save As... to download, then click back to return to this page.")) {
              location.href = url2;
            }
          }
          return true;
        }
        var f = document.createElement("iframe");
        document.body.appendChild(f);
        if (!winMode && /^data:/.test(url2)) {
          url2 = "data:" + url2.replace(/^data:([\w\/\-\+]+)/, defaultMime);
        }
        f.src = url2;
        setTimeout(function() {
          document.body.removeChild(f);
        }, 333);
      }
      if (navigator.msSaveBlob) {
        return navigator.msSaveBlob(blob, fileName);
      }
      if (self2.URL) {
        saver(self2.URL.createObjectURL(blob), true);
      } else {
        if (typeof blob === "string" || blob.constructor === toString) {
          try {
            return saver("data:" + mimeType + ";base64," + self2.btoa(blob));
          } catch (y) {
            return saver("data:" + mimeType + "," + encodeURIComponent(blob));
          }
        }
        reader = new FileReader();
        reader.onload = function(e) {
          saver(this.result);
        };
        reader.readAsDataURL(blob);
      }
      return true;
    };
  });
})(download$1);
var download = download$1.exports;
var _export_sfc = (sfc, props) => {
  const target = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target[key] = val;
  }
  return target;
};
const _sfc_main = {
  name: "vue3-json-excel",
  props: {
    type: {
      type: String,
      default: "xls"
    },
    jsonData: {
      type: Array,
      required: false,
      default: null
    },
    fields: {
      type: Object,
      default: () => null
    },
    exportFields: {
      type: Object,
      default: () => null
    },
    defaultValue: {
      type: String,
      required: false,
      default: ""
    },
    header: {
      default: ""
    },
    footer: {
      default: ""
    },
    name: {
      type: String,
      default: "jsonData.xls"
    },
    fetch: {
      type: Function
    },
    meta: {
      type: Array,
      default: () => []
    },
    worksheet: {
      type: String,
      default: "\u88681"
    },
    beforeGenerate: {
      type: Function
    },
    beforeFinish: {
      type: Function
    },
    escapeCsv: {
      type: Boolean,
      default: true
    },
    stringifyLongNum: {
      type: Boolean,
      default: false
    }
  },
  setup(props) {
    const {
      type,
      fields,
      exportFields,
      beforeFinish,
      header,
      footer,
      stringifyLongNum,
      beforeGenerate,
      jsonData,
      fetch,
      defaultValue,
      name,
      worksheet
    } = toRefs(props);
    const idName = computed(() => {
      var now = new Date().getTime();
      return "export_" + now;
    });
    const downloadFields = computed(() => {
      if (fields)
        return toRaw(fields.value);
      if (exportFields)
        return exportFields.value();
    });
    const export1 = async (data1, filename, mine) => {
      let blob = base64ToBlob(data1, mine);
      if (typeof beforeFinish === "function")
        await beforeFinish();
      download(blob, filename, mine);
    };
    const base64ToBlob = (data1, mine) => {
      let base64 = window.btoa(window.unescape(encodeURIComponent(data1)));
      let bstr = atob(base64);
      let n = bstr.length;
      let u8arr = new Uint8ClampedArray(n);
      while (n--) {
        u8arr[n] = bstr.charCodeAt(n);
      }
      return new Blob([u8arr], { type: mine });
    };
    const jsonToXLS = (data1) => {
      let xlsTemp = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><meta name=ProgId content=Excel.Sheet> <meta name=Generator content="Microsoft Excel 11"><meta http-equiv="Content-Type" content="text/html; charset=UTF-8"><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>${worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--><style>br {mso-data-placement: same-cell;}</style></head><body><table>${table}</table></body></html>';
      let xlsData = "<thead>";
      const colspan = Object.keys(data1[0]).length;
      if (header.value) {
        xlsData += parseExtraData(header.value, '<tr><th colspan="' + colspan + '">${data}</th></tr>');
      }
      xlsData += "<tr>";
      for (let key in data1[0]) {
        xlsData += "<th>" + key + "</th>";
      }
      xlsData += "</tr>";
      xlsData += "</thead>";
      xlsData += "<tbody>";
      data1.map(function(item, index2) {
        xlsData += "<tr>";
        for (let key in item) {
          xlsData += "<td>" + preprocessLongNum(valueReformattedForMultilines(item[key])) + "</td>";
        }
        xlsData += "</tr>";
      });
      xlsData += "</tbody>";
      if (footer.value) {
        xlsData += "<tfoot>";
        xlsData += parseExtraData(footer.value, '<tr><td colspan="' + colspan + '">${data}</td></tr>');
        xlsData += "</tfoot>";
      }
      return xlsTemp.replace("${table}", xlsData).replace("${worksheet}", worksheet.value);
    };
    const parseExtraData = (extraData, format) => {
      let parseData = "";
      if (Array.isArray(extraData)) {
        for (var i = 0; i < extraData.length; i++) {
          if (extraData[i])
            parseData += format.replace("${data}", extraData[i]);
        }
      } else {
        parseData += format.replace("${data}", extraData);
      }
      return parseData;
    };
    const preprocessLongNum = (value) => {
      if (stringifyLongNum.value) {
        if (String(value).startsWith("0x")) {
          return value;
        }
        if (!isNaN(value) && value != "") {
          if (value > 99999999999 || value < 1e-13) {
            return '="' + value + '"';
          }
        }
      }
      return value;
    };
    const valueReformattedForMultilines = (value) => {
      if (typeof value == "string")
        return value.replace(/\n/gi, "<br/>");
      else
        return value;
    };
    const getKeys = (data1, header1) => {
      if (header1) {
        return header1;
      }
      let keys = {};
      for (let key in data1[0]) {
        keys[key] = key;
      }
      return keys;
    };
    const parseValue = (value) => {
      return value || value === 0 || typeof value === "boolean" ? value : defaultValue.value;
    };
    const getValueFromNestedItem = (item, indexes) => {
      let nestedItem = item;
      for (let index2 of indexes) {
        if (nestedItem)
          nestedItem = nestedItem[index2];
      }
      return parseValue(nestedItem);
    };
    const getValueFromCallback = (item, callback) => {
      if (typeof callback !== "function")
        return defaultValue.value;
      const value = callback(item);
      return parseValue(value);
    };
    const getValue = (key, item) => {
      const field = typeof key !== "object" ? key : key.field;
      let indexes = typeof field !== "string" ? [] : field.split(".");
      let value = defaultValue.value;
      if (!field)
        value = item;
      else if (indexes.length > 1)
        value = getValueFromNestedItem(item, indexes);
      else
        value = parseValue(item[field]);
      if (key.hasOwnProperty("callback"))
        value = getValueFromCallback(value, key.callback);
      return value;
    };
    const getProcessedJson = (data1, header1) => {
      let keys = getKeys(data1, header1).value;
      let newData = [];
      data1.map(function(item, index2) {
        let newItem = {};
        for (let label in keys) {
          let property = keys[label];
          newItem[label] = getValue(property, item);
        }
        newData.push(newItem);
      });
      return newData;
    };
    const generate = async () => {
      if (beforeGenerate && typeof beforeGenerate.value === "function") {
        await beforeGenerate.value();
      }
      let data2 = jsonData && toRaw(jsonData.value);
      if (fetch && typeof fetch.value === "function" || !jsonData) {
        data2 = await fetch.value();
      }
      if (data2.length === 0) {
        console.warn("\u65E0\u5BFC\u51FA\u6570\u636E");
        return;
      }
      const DATA = toRaw(data2);
      let json = getProcessedJson(DATA, downloadFields);
      if (type.value === "html") {
        return export1(jsonToXLS(json), name.value.replace(".xls", ".html"), "text/html");
      }
      return export1(jsonToXLS(json), name.value, "application/vnd.ms-excel");
    };
    return {
      idName,
      generate,
      name
    };
  }
};
const _hoisted_1 = ["id"];
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("span", {
    id: $setup.idName,
    onClick: _cache[0] || (_cache[0] = (...args) => $setup.generate && $setup.generate(...args))
  }, [
    renderSlot(_ctx.$slots, "default", {}, () => [
      createTextVNode(" Download " + toDisplayString($setup.name), 1)
    ])
  ], 8, _hoisted_1);
}
var Vue3JsonExcel = /* @__PURE__ */ _export_sfc(_sfc_main, [["render", _sfc_render]]);
const version = "1.0.10";
const VERSION = version;
console.log("version:" + VERSION);
const install = (app) => {
  app.component(Vue3JsonExcel.name, Vue3JsonExcel);
};
var index = {
  Vue3JsonExcel,
  install
};
export { index as default };
