# JSON to Excel for VUE3
在浏览器中将JSON格式数据以excel文件的形式下载。该组件是基于[this thread] (https://stackoverflow.com/questions/17142427/javascript-to-export-html-table-to-excel)提出的解决方案。支持Vue3.2.25及以上版本使用

### 重要提示! Microsoft Excel中的额外提示

**此组件中实现的方法使用HTML表绘制。在xls文件中，Microsoft Excel不再将HTML识别为本机内容，因此在打开文件之前会显示警告消息。excel的内容已经完美呈现，但是提示信息无法避免，请不要在意！**

## Getting started
安装依赖：

```bash
npm install vue3-json-excel
```

在vue3的应用入口处有两种注册组件的方式：

```js
import Vue from "vue"
import {vue3JsonExcel} from "vue3-json-excel"

Vue.component("vue3JsonExcel", vue3JsonExcel)
```

或者

```js
import Vue from "vue"
import vue3JsonExcel from "vue3-json-excel"

Vue.use(vue3JsonExcel)
```

在template文件中直接使用即可

```html
<vue3-json-excel :json-data="json_data">
  Download Data
</vue3-json-excel>
```

## Props List

| Name                         |     Type     | Description                                                                                                                                                                                              | Default  |  remark |
| :--------------------------- | :----------: | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :------: | :------: |
| json-data                         |    Array     | 即将导出的数据                                                                                                                                                                                     |
| fields                       |    Object    | 要导出的JSON对象内的字段。如果未提供任何属性，将导出JSON中的所有属性。                                                                                    |
| export-fields (exportFields) |    Object    | 用于修复使用变量字段的其他组件的问题，如vee-validate。exportFields的工作原理与fields完全相同                                                                   |
| type                         |    string    | Mime 类型 [xls, csv]                                                                                                                                                                                     |   xls    | 1.0.x版本暂时只支持xls，csv会在下个版本迭代
| name                         |    string    | File 导出的文件名                                                                                                                                                                                     | jsonData.xls |
| header                       | string/Array | 数据的标题。可以是字符串（一个标题）或字符串数组（多个标题）。                                                                                   |
| title(deprecated)            | string/Array | 与header相同，title是出于追溯兼容性目的而维护的，但由于与HTML5 title属性冲突，不建议使用它。                                             |


## Example
```js
// 待补充
```

## License

MIT

### Status

该项目处于早期开发阶段。欢迎参与共建 :D


