/*
 * vue3-form-wizard
 * Creator:parsa jiravand
 * vue3-form-wizard is a vue based component with no external depenendcies which simplifies tab wizard management.
 * v0.2.4
 * MIT License
 */

import { openBlock as l, createElementBlock as o, renderSlot as d, normalizeClass as h, createElementVNode as c, normalizeStyle as b, toDisplayString as u, resolveComponent as C, withKeys as T, createCommentVNode as g, Fragment as P, renderList as O, createVNode as m, normalizeProps as f, guardReactiveProps as v, withCtx as I, createTextVNode as k, withDirectives as A, vShow as L } from "vue";
const x = (t, a) => {
  const e = t.__vccOpts || t;
  for (const [n, s] of a)
    e[n] = s;
  return e;
}, V = {}, N = {
  class: "wizard-btn",
  tabindex: "-1",
  type: "button"
};
function F(t, a, e, n, s, i) {
  return l(), o("button", N, [
    d(t.$slots, "default")
  ]);
}
const B = /* @__PURE__ */ x(V, [["render", F]]), K = {
  name: "wizard-step",
  props: {
    tab: {
      type: Object,
      default: () => {
      }
    },
    transition: {
      type: String,
      default: ""
    },
    index: {
      type: Number,
      default: 0
    },
    disableBackOnClickStep: {
      type: Boolean,
      default: !1
    }
  },
  computed: {
    iconActiveStyleBg() {
      return {
        backgroundColor: this.tab.color
      };
    },
    iconActiveStyle() {
      if (!this.tab.active)
        return { color: this.tab.color };
    },
    stepCheckedStyle() {
      return {
        borderColor: this.tab.color
      };
    },
    errorStyle() {
      return {
        borderColor: this.tab.errorColor,
        backgroundColor: this.tab.errorColor
      };
    },
    stepTitleStyle() {
      return {
        color: this.tab.validationError ? this.tab.errorColor : this.tab.color
      };
    },
    isStepSquare() {
      return this.tab.shape === "square";
    },
    isTabShape() {
      return this.tab.shape === "tab";
    },
    cursorStyle() {
      return this.disableBackOnClickStep ? "cursor: default" : "";
    }
  }
}, R = ["tabindex", "id", "aria-controls", "aria-disabled", "aria-selected"], q = ["innerHTML"], M = ["innerHTML"];
function W(t, a, e, n, s, i) {
  return l(), o("li", {
    class: h({ active: e.tab.active })
  }, [
    c("a", {
      class: h({ disabled: !e.tab.checked }),
      style: b(i.cursorStyle)
    }, [
      c("div", {
        class: h(["wizard-icon-circle md", {
          checked: e.tab.checked,
          square_shape: i.isStepSquare,
          tab_shape: i.isTabShape
        }]),
        role: "tab",
        tabindex: e.tab.checked ? 0 : "",
        id: `step-${e.tab.tabId}`,
        "aria-controls": e.tab.tabId,
        "aria-disabled": e.tab.active,
        "aria-selected": e.tab.active,
        style: b([
          e.tab.checked ? i.stepCheckedStyle : {},
          e.tab.validationError ? i.errorStyle : {}
        ])
      }, [
        e.tab.active ? (l(), o("div", {
          key: 0,
          class: h(["wizard-icon-container", { square_shape: i.isStepSquare, tab_shape: i.isTabShape }]),
          style: b([i.iconActiveStyleBg, e.tab.validationError ? i.errorStyle : {}])
        }, [
          d(t.$slots, "active-step", {}, () => [
            e.tab.customIcon ? (l(), o("span", {
              key: 0,
              class: "wizard-icon",
              innerHTML: e.tab.customIcon
            }, null, 8, q)) : (l(), o("i", {
              key: 1,
              class: h([e.tab.icon ? e.tab.icon : "", "wizard-icon"]),
              style: b(e.tab.checked ? i.iconActiveStyle : "")
            }, u(e.tab.icon ? null : e.index + 1), 7))
          ])
        ], 6)) : d(t.$slots, "default", { key: 1 }, () => [
          e.tab.customIcon ? (l(), o("span", {
            key: 0,
            class: "wizard-icon",
            innerHTML: e.tab.customIcon
          }, null, 8, M)) : (l(), o("i", {
            key: 1,
            class: h([e.tab.icon ? e.tab.icon : "", "wizard-icon"]),
            style: b(e.tab.checked ? i.iconActiveStyle : "")
          }, u(e.tab.icon ? null : e.index + 1), 7))
        ])
      ], 14, R),
      d(t.$slots, "title", {}, () => [
        c("span", {
          class: h(["stepTitle", { active: e.tab.active, has_error: e.tab.validationError }]),
          style: b([e.tab.active || e.tab.checked ? i.stepTitleStyle : {}, { "margin-top": "5px" }])
        }, u(e.tab.title), 7)
      ]),
      d(t.$slots, "customIcon")
    ], 6)
  ], 2);
}
const _ = /* @__PURE__ */ x(K, [["render", W]]);
function j() {
  return document.activeElement.id;
}
function p(t = []) {
  let a = j();
  return t.findIndex((n) => n.tabId === a);
}
function z(t) {
  document.getElementById(t).focus();
}
function H(t) {
  return t.then && typeof t.then == "function";
}
const D = {
  name: "form-wizard",
  components: {
    WizardButton: B,
    WizardStep: _
  },
  props: {
    id: {
      type: String,
      default: "fw_" + new Date().valueOf()
    },
    title: {
      type: String,
      default: "Awesome Wizard"
    },
    subtitle: {
      type: String,
      default: "Split a complicated flow in multiple steps"
    },
    nextButtonText: {
      type: String,
      default: "Next"
    },
    backButtonText: {
      type: String,
      default: "Back"
    },
    finishButtonText: {
      type: String,
      default: "Finish"
    },
    hideButtons: {
      type: Boolean,
      default: !1
    },
    validateOnBack: Boolean,
    color: {
      type: String,
      default: "#e74c3c"
    },
    errorColor: {
      type: String,
      default: "#8b0000"
    },
    shape: {
      type: String,
      default: "circle"
    },
    layout: {
      type: String,
      default: "horizontal"
    },
    stepsClasses: {
      type: [String, Array],
      default: ""
    },
    stepSize: {
      type: String,
      default: "md",
      validator: (t) => ["xs", "sm", "md", "lg"].indexOf(t) !== -1
    },
    transition: {
      type: String,
      default: ""
    },
    startIndex: {
      type: Number,
      default: 0,
      validator: (t) => t >= 0
    },
    disableBackOnClickStep: {
      type: Boolean,
      default: !1
    },
    disableBack: {
      type: Boolean,
      default: !1
    }
  },
  provide() {
    return {
      addTab: this.addTab,
      removeTab: this.removeTab
    };
  },
  data() {
    return {
      activeTabIndex: 0,
      currentPercentage: 0,
      maxStep: 0,
      loading: !1,
      tabs: []
    };
  },
  computed: {
    slotProps() {
      return {
        nextTab: this.nextTab,
        prevTab: this.prevTab,
        activeTabIndex: this.activeTabIndex,
        isLastStep: this.isLastStep,
        fillButtonStyle: this.fillButtonStyle
      };
    },
    tabCount() {
      return this.tabs.length;
    },
    isLastStep() {
      return this.activeTabIndex === this.tabCount - 1;
    },
    isVertical() {
      return this.layout === "vertical";
    },
    displayPrevButton() {
      return this.activeTabIndex !== 0;
    },
    stepPercentage() {
      return 1 / (this.tabCount * 2) * 100;
    },
    progressBarStyle() {
      return {
        backgroundColor: this.color,
        width: `${this.progress}%`,
        color: this.color
      };
    },
    fillButtonStyle() {
      return {
        backgroundColor: this.color,
        borderColor: this.color,
        color: "white"
      };
    },
    progress() {
      let t = 0;
      if (this.activeTabIndex > 0) {
        let a = 1, e = 2;
        t = this.stepPercentage * (this.activeTabIndex * e + a);
      } else
        t = this.stepPercentage;
      return t;
    }
  },
  methods: {
    emitTabChange(t, a) {
      this.$emit("on-change", t, a), this.$emit("update:startIndex", a);
    },
    addTab(t) {
      const a = this.tabCount;
      t.tabId = `${t.title.replace(/ /g, "")}${a}`, this.tabs.splice(a, 0, t), a < this.activeTabIndex + 1 && (this.maxStep = a, this.changeTab(this.activeTabIndex + 1, a));
    },
    removeTab(t) {
      const a = this.tabs, e = a.indexOf(t);
      e > -1 && (e === this.activeTabIndex && (this.maxStep = this.activeTabIndex - 1, this.changeTab(this.activeTabIndex, this.activeTabIndex - 1)), e < this.activeTabIndex && (this.maxStep = this.activeTabIndex - 1, this.activeTabIndex = this.activeTabIndex - 1, this.emitTabChange(this.activeTabIndex + 1, this.activeTabIndex)), a.splice(e, 1));
    },
    reset() {
      this.maxStep = 0, this.tabs.forEach((t) => {
        t.checked = !1;
      }), this.navigateToTab(0);
    },
    activateAll() {
      this.maxStep = this.tabs.length - 1, this.tabs.forEach((t) => {
        t.checked = !0;
      });
    },
    navigateToTab(t) {
      let a = t > this.activeTabIndex;
      if (t <= this.maxStep) {
        let e = () => {
          a && t - this.activeTabIndex > 1 ? (this.changeTab(this.activeTabIndex, this.activeTabIndex + 1), this.beforeTabChange(this.activeTabIndex, e)) : (this.changeTab(this.activeTabIndex, t), this.afterTabChange(this.activeTabIndex));
        };
        a ? this.beforeTabChange(this.activeTabIndex, e) : (this.setValidationError(null), e());
      }
      return t <= this.maxStep;
    },
    nextTab() {
      let t = () => {
        this.activeTabIndex < this.tabCount - 1 ? (this.changeTab(this.activeTabIndex, this.activeTabIndex + 1), this.afterTabChange(this.activeTabIndex)) : this.$emit("on-complete");
      };
      this.beforeTabChange(this.activeTabIndex, t);
    },
    prevTab() {
      let t = () => {
        this.activeTabIndex > 0 && (this.setValidationError(null), this.changeTab(this.activeTabIndex, this.activeTabIndex - 1));
      };
      this.validateOnBack ? this.beforeTabChange(this.activeTabIndex, t) : t();
    },
    focusNextTab() {
      let t = p(this.tabs);
      if (t !== -1 && t < this.tabs.length - 1) {
        let a = this.tabs[t + 1];
        a.checked && z(a.tabId);
      }
    },
    focusPrevTab() {
      let t = p(this.tabs);
      if (t !== -1 && t > 0) {
        let a = this.tabs[t - 1].tabId;
        z(a);
      }
    },
    setLoading(t) {
      this.loading = t, this.$emit("on-loading", t);
    },
    setValidationError(t) {
      this.tabs[this.activeTabIndex].validationError = t, this.$emit("on-error", t);
    },
    validateBeforeChange(t, a) {
      if (this.setValidationError(null), H(t))
        this.setLoading(!0), t.then((e) => {
          this.setLoading(!1);
          let n = e === !0;
          this.executeBeforeChange(n, a);
        }).catch((e) => {
          this.setLoading(!1), this.setValidationError(e);
        });
      else {
        let e = t === !0;
        this.executeBeforeChange(e, a);
      }
    },
    executeBeforeChange(t, a) {
      this.$emit("on-validate", t, this.activeTabIndex), t ? a() : this.tabs[this.activeTabIndex].validationError = "error";
    },
    beforeTabChange(t, a) {
      if (this.loading)
        return;
      let e = this.tabs[t];
      if (e && e.beforeChange !== void 0) {
        let n = e.beforeChange();
        this.validateBeforeChange(n, a);
      } else
        a();
    },
    afterTabChange(t) {
      if (this.loading)
        return;
      let a = this.tabs[t];
      a && a.afterChange !== void 0 && a.afterChange();
    },
    changeTab(t, a, e = !0) {
      let n = this.tabs[t], s = this.tabs[a];
      return n && (n.active = !1), s && (s.active = !0), e && this.activeTabIndex !== a && this.emitTabChange(t, a), this.activeTabIndex = a, this.activateTabAndCheckStep(this.activeTabIndex), !0;
    },
    tryChangeRoute(t) {
      this.$router && t.route && this.$router.push(t.route);
    },
    checkRouteChange(t) {
      let a = -1, e = this.tabs.find((n, s) => {
        let i = n.route === t;
        return i && (a = s), i;
      });
      if (e && !e.active) {
        const n = a > this.activeTabIndex;
        this.navigateToTab(a, n);
      }
    },
    deactivateTabs() {
      this.tabs.forEach((t) => {
        t.active = !1;
      });
    },
    activateTab(t) {
      this.deactivateTabs();
      let a = this.tabs[t];
      a && (a.active = !0, a.checked = !0, this.tryChangeRoute(a));
    },
    activateTabAndCheckStep(t) {
      this.activateTab(t), t > this.maxStep && (this.maxStep = t), this.activeTabIndex = t;
    },
    initializeTabs() {
      this.tabs.length > 0 && this.startIndex === 0 && this.activateTab(this.activeTabIndex), this.startIndex < this.tabs.length ? this.activateTabAndCheckStep(this.startIndex) : window.console.warn(
        `Prop startIndex set to ${this.startIndex} is greater than the number of tabs - ${this.tabs.length}. Make sure that the starting index is less than the number of tabs registered`
      );
    }
  },
  mounted() {
    this.initializeTabs();
  },
  watch: {
    "$route.path"(t) {
      this.checkRouteChange(t);
    }
  }
}, G = ["id"], J = {
  key: 0,
  class: "wizard-header"
}, Q = { class: "wizard-title" }, U = { class: "category" }, X = { class: "wizard-navigation" }, Y = {
  key: 0,
  class: "wizard-progress-with-circle"
}, Z = { class: "wizard-tab-content" }, $ = {
  key: 1,
  class: "wizard-card-footer clearfix"
}, tt = {
  key: 0,
  class: "wizard-footer-left"
}, et = { class: "wizard-footer-right" };
function at(t, a, e, n, s, i) {
  const w = C("wizard-step"), S = C("wizard-button");
  return l(), o("div", {
    id: e.id ? e.id : "",
    class: h(["vue-form-wizard", [e.stepSize, { vertical: i.isVertical }]]),
    onKeyup: [
      a[6] || (a[6] = T((...r) => i.focusNextTab && i.focusNextTab(...r), ["right"])),
      a[7] || (a[7] = T((...r) => i.focusPrevTab && i.focusPrevTab(...r), ["left"]))
    ]
  }, [
    t.$slots.title ? (l(), o("div", J, [
      d(t.$slots, "title", {}, () => [
        c("h4", Q, u(e.title), 1),
        c("p", U, u(e.subtitle), 1)
      ])
    ])) : g("", !0),
    c("div", X, [
      i.isVertical ? g("", !0) : (l(), o("div", Y, [
        c("div", {
          class: "wizard-progress-bar",
          style: b(i.progressBarStyle)
        }, null, 4)
      ])),
      c("ul", {
        class: h(["wizard-nav wizard-nav-pills", e.stepsClasses]),
        role: "tablist"
      }, [
        (l(!0), o(P, null, O(s.tabs, (r, y) => d(t.$slots, "step", {
          tab: r,
          index: y,
          navigateToTab: i.navigateToTab,
          stepSize: e.stepSize,
          transition: e.transition
        }, () => [
          m(w, {
            tab: r,
            "step-size": e.stepSize,
            onClick: (E) => e.disableBackOnClickStep || e.disableBack ? !1 : i.navigateToTab(y),
            onKeyup: T((E) => i.navigateToTab(y), ["enter"]),
            transition: e.transition,
            index: y,
            "disable-back-on-click-step": e.disableBack ? !0 : e.disableBackOnClickStep
          }, null, 8, ["tab", "step-size", "onClick", "onKeyup", "transition", "index", "disable-back-on-click-step"])
        ])), 256))
      ], 2),
      c("div", Z, [
        d(t.$slots, "default", f(v(i.slotProps)))
      ])
    ]),
    e.hideButtons ? g("", !0) : (l(), o("div", $, [
      d(t.$slots, "footer", f(v(i.slotProps)), () => [
        e.disableBack ? g("", !0) : (l(), o("div", tt, [
          i.displayPrevButton ? (l(), o("span", {
            key: 0,
            onClick: a[0] || (a[0] = (...r) => i.prevTab && i.prevTab(...r)),
            onKeyup: a[1] || (a[1] = T((...r) => i.prevTab && i.prevTab(...r), ["enter"])),
            role: "button",
            tabindex: "0"
          }, [
            d(t.$slots, "prev", f(v(i.slotProps)), () => [
              m(S, {
                style: b(i.fillButtonStyle),
                disabled: s.loading
              }, {
                default: I(() => [
                  k(u(e.backButtonText), 1)
                ]),
                _: 1
              }, 8, ["style", "disabled"])
            ])
          ], 32)) : g("", !0),
          d(t.$slots, "custom-buttons-left", f(v(i.slotProps)))
        ])),
        c("div", et, [
          d(t.$slots, "custom-buttons-right", f(v(i.slotProps))),
          i.isLastStep ? (l(), o("span", {
            key: 0,
            onClick: a[2] || (a[2] = (...r) => i.nextTab && i.nextTab(...r)),
            onKeyup: a[3] || (a[3] = T((...r) => i.nextTab && i.nextTab(...r), ["enter"])),
            role: "button",
            tabindex: "0"
          }, [
            d(t.$slots, "finish", f(v(i.slotProps)), () => [
              m(S, {
                style: b(i.fillButtonStyle)
              }, {
                default: I(() => [
                  k(u(e.finishButtonText), 1)
                ]),
                _: 1
              }, 8, ["style"])
            ])
          ], 32)) : (l(), o("span", {
            key: 1,
            onClick: a[4] || (a[4] = (...r) => i.nextTab && i.nextTab(...r)),
            onKeyup: a[5] || (a[5] = T((...r) => i.nextTab && i.nextTab(...r), ["enter"])),
            role: "button",
            tabindex: "0"
          }, [
            d(t.$slots, "next", f(v(i.slotProps)), () => [
              m(S, {
                style: b(i.fillButtonStyle),
                disabled: s.loading
              }, {
                default: I(() => [
                  k(u(e.nextButtonText), 1)
                ]),
                _: 1
              }, 8, ["style", "disabled"])
            ])
          ], 32))
        ])
      ])
    ]))
  ], 42, G);
}
const it = /* @__PURE__ */ x(D, [["render", at]]), st = {
  name: "tab-content",
  props: {
    title: {
      type: String,
      default: ""
    },
    icon: {
      type: String,
      default: ""
    },
    customIcon: {
      type: String,
      default: ""
    },
    lazy: {
      type: Boolean,
      default: !1
    },
    beforeChange: {
      type: Function
    },
    afterChange: {
      type: Function
    },
    route: {
      type: [String, Object]
    },
    additionalInfo: {
      type: Object,
      default: () => {
      }
    }
  },
  inject: ["addTab", "removeTab"],
  data() {
    return {
      active: !1,
      validationError: null,
      checked: !1,
      tabId: ""
    };
  },
  computed: {
    shape() {
      return this.$parent.shape;
    },
    color() {
      return this.$parent.color;
    },
    errorColor() {
      return this.$parent.errorColor;
    }
  },
  mounted() {
    this.addTab(this);
  },
  destroyed() {
    this.$el && this.$el.parentNode && this.$el.parentNode.removeChild(this.$el), this.removeTab(this);
  }
}, nt = ["id", "aria-hidden", "aria-labelledby"];
function rt(t, a, e, n, s, i) {
  return !e.lazy || s.active ? A((l(), o("div", {
    key: 0,
    class: "wizard-tab-container",
    role: "tabpanel",
    id: s.tabId,
    "aria-hidden": !s.active,
    "aria-labelledby": `step-${s.tabId}`
  }, [
    d(t.$slots, "default", { active: s.active }),
    d(t.$slots, "customIcon")
  ], 8, nt)), [
    [L, s.active]
  ]) : g("", !0);
}
const lt = /* @__PURE__ */ x(st, [["render", rt]]), dt = {
  install(t) {
    t.component("form-wizard", it), t.component("tab-content", lt), t.component("wizard-button", B), t.component("wizard-step", _);
  }
};
export {
  it as FormWizard,
  lt as TabContent,
  B as WizardButton,
  _ as WizardStep,
  dt as default
};
