declare const _default: import("vue").DefineComponent<{
    id: {
        type: StringConstructor;
        default: string;
    };
    title: {
        type: StringConstructor;
        default: string;
    };
    subtitle: {
        type: StringConstructor;
        default: string;
    };
    nextButtonText: {
        type: StringConstructor;
        default: string;
    };
    backButtonText: {
        type: StringConstructor;
        default: string;
    };
    finishButtonText: {
        type: StringConstructor;
        default: string;
    };
    hideButtons: {
        type: BooleanConstructor;
        default: boolean;
    };
    validateOnBack: BooleanConstructor;
    /***
     * Applies to text, border and circle
     */
    color: {
        type: StringConstructor;
        default: string;
    };
    errorColor: {
        type: StringConstructor;
        default: string;
    };
    shape: {
        type: StringConstructor;
        default: string;
    };
    layout: {
        type: StringConstructor;
        default: string;
    };
    stepsClasses: {
        type: (StringConstructor | ArrayConstructor)[];
        default: string;
    };
    stepSize: {
        type: StringConstructor;
        default: string;
        validator: (value: unknown) => boolean;
    };
    /**
     * Name of the transition when transition between steps
     * */
    transition: {
        type: StringConstructor;
        default: string;
    };
    /***
     *
     * Index of the initial tab to display
     */
    startIndex: {
        type: NumberConstructor;
        default: number;
        validator: (value: unknown) => boolean;
    };
    disableBackOnClickStep: {
        type: BooleanConstructor;
        default: boolean;
    };
    disableBack: {
        type: BooleanConstructor;
        default: boolean;
    };
}, any, {
    activeTabIndex: number;
    currentPercentage: number;
    maxStep: number;
    loading: boolean;
    tabs: any[];
}, {
    slotProps(): {
        nextTab: () => void;
        prevTab: () => void;
        activeTabIndex: number;
        isLastStep: boolean;
        fillButtonStyle: {
            backgroundColor: string;
            borderColor: string;
            color: string;
        };
    };
    tabCount(): number;
    isLastStep(): boolean;
    isVertical(): boolean;
    displayPrevButton(): boolean;
    stepPercentage(): number;
    progressBarStyle(): {
        backgroundColor: string;
        width: string;
        color: string;
    };
    fillButtonStyle(): {
        backgroundColor: string;
        borderColor: string;
        color: string;
    };
    progress(): number;
}, {
    emitTabChange(prevIndex: any, nextIndex: any): void;
    addTab(item: any): void;
    removeTab(item: any): void;
    reset(): void;
    activateAll(): void;
    navigateToTab(index: any): boolean;
    nextTab(): void;
    prevTab(): void;
    focusNextTab(): void;
    focusPrevTab(): void;
    setLoading(value: any): void;
    setValidationError(error: any): void;
    validateBeforeChange(promiseFn: any, callback: any): void;
    executeBeforeChange(validationResult: any, callback: any): void;
    beforeTabChange(index: any, callback: any): void;
    afterTabChange(index: any): void;
    changeTab(oldIndex: any, newIndex: any, emitChangeEvent?: boolean): true;
    tryChangeRoute(tab: any): void;
    checkRouteChange(route: any): void;
    deactivateTabs(): void;
    activateTab(index: any): void;
    activateTabAndCheckStep(index: any): void;
    initializeTabs(): void;
}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, Record<string, any>, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    id?: unknown;
    title?: unknown;
    subtitle?: unknown;
    nextButtonText?: unknown;
    backButtonText?: unknown;
    finishButtonText?: unknown;
    hideButtons?: unknown;
    validateOnBack?: unknown;
    color?: unknown;
    errorColor?: unknown;
    shape?: unknown;
    layout?: unknown;
    stepsClasses?: unknown;
    stepSize?: unknown;
    transition?: unknown;
    startIndex?: unknown;
    disableBackOnClickStep?: unknown;
    disableBack?: unknown;
} & {
    id: string;
    color: string;
    transition: string;
    title: string;
    layout: string;
    shape: string;
    disableBackOnClickStep: boolean;
    subtitle: string;
    nextButtonText: string;
    backButtonText: string;
    finishButtonText: string;
    hideButtons: boolean;
    validateOnBack: boolean;
    errorColor: string;
    stepsClasses: string | unknown[];
    stepSize: string;
    startIndex: number;
    disableBack: boolean;
} & {}>, {
    id: string;
    color: string;
    transition: string;
    title: string;
    layout: string;
    shape: string;
    disableBackOnClickStep: boolean;
    subtitle: string;
    nextButtonText: string;
    backButtonText: string;
    finishButtonText: string;
    hideButtons: boolean;
    validateOnBack: boolean;
    errorColor: string;
    stepsClasses: string | unknown[];
    stepSize: string;
    startIndex: number;
    disableBack: boolean;
}>;
export default _default;
