var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
import { defineComponent, ref, onMounted, watch, onUnmounted, openBlock, createElementBlock, createElementVNode } from "vue";
import EasyMDE from "easymde";
const _hoisted_1 = { class: "vue-easymde-editor" };
const _sfc_main = /* @__PURE__ */ defineComponent({
  props: {
    modelValue: { default: "" },
    options: null
  },
  emits: ["update:modelValue", "change", "blur"],
  setup(__props, { expose, emit }) {
    const props = __props;
    const textArea = ref();
    let easyMDEInstance = null;
    const innerValue = ref(props.modelValue);
    onMounted(() => {
      if (textArea.value) {
        const config = __spreadProps(__spreadValues({}, props.options || {}), {
          element: textArea.value
        });
        easyMDEInstance = new EasyMDE(config);
        easyMDEInstance.value(props.modelValue);
        easyMDEInstance.codemirror.on("change", () => {
          if (easyMDEInstance) {
            const updatedValue = easyMDEInstance.value();
            innerValue.value = updatedValue;
            emit("update:modelValue", updatedValue);
            emit("change", updatedValue);
          }
        });
        easyMDEInstance.codemirror.on("blur", () => {
          if (easyMDEInstance) {
            emit("blur");
          }
        });
      }
    });
    watch(() => props.modelValue, (newValue) => {
      if (easyMDEInstance) {
        if (newValue !== innerValue.value) {
          easyMDEInstance.value(newValue || "");
        }
      }
    });
    const clear = () => {
      if (easyMDEInstance) {
        easyMDEInstance.value("");
      }
    };
    const getMDEInstance = () => {
      return easyMDEInstance;
    };
    expose({
      clear,
      getMDEInstance
    });
    onUnmounted(() => {
      if (easyMDEInstance) {
        easyMDEInstance.cleanup();
      }
      easyMDEInstance = null;
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1, [
        createElementVNode("textarea", {
          ref_key: "textArea",
          ref: textArea
        }, "\n    ", 512)
      ]);
    };
  }
});
const install = (app) => {
  app.component("VueEasymde", _sfc_main);
};
var index = {
  install
};
export { _sfc_main as VueEasyMDE, index as default };
