'use strict';//
//
//
//
//
//
//
//
//
//
//
let COLLAPSED = 'collapsed';
let COLLAPSING = 'collapsing';
let EXPANDING = 'expanding';
let EXPANDED = 'expanded';
let collapseHeight = '0px';

let nextFrame = callback => requestAnimationFrame(() => {
  requestAnimationFrame(callback);
});

var script = {
  name: 'HeightCollapsible',
  props: {
    isOpen: {
      type: Boolean,
      required: true,
      default: true
    },
    overflowOnExpanded: {
      type: Boolean,
      default: false
    },
    tag: {
      type: String,
      default: 'div'
    },
    transition: {
      type: String,
      default: null
    }
  },

  data() {
    return {
      collapseState: this.isOpen ? EXPANDED : COLLAPSED,
      isMounted: false
    };
  },

  watch: {
    isOpen(current, previous) {
      if (!this.isMounted) {
        this.$emit('error', {
          type: 'isOpen',
          msg: 'not mounted yet'
        });
        return;
      }

      if (current && !previous) this.setExpanding();
      if (!current && previous) this.setCollapsing();
    },

    transition(current, previous) {
      if (current !== previous && this.$refs.root) {
        this.$refs.root.style.transition = current;
      }
    }

  },

  mounted() {
    if (this.isOpen) this.setExpanded();else this.setCollapsed();

    if (this.transition) {
      this.$refs.root.style.transition = this.transition;
    }

    this.$refs.root.addEventListener('transitionend', this.onTransitionEnd);
    this.isMounted = true;
  },

  beforeDestroy() {
    this.$refs.root.removeEventListener('transitionend', this.onTransitionEnd);
  },

  // beforeUnmount() {
  //   this.$refs.root.removeEventListener('transitionend', this.onTransitionEnd)
  // },
  methods: {
    setCollapsed() {
      if (!this.$refs.root) return;
      this.collapseState = COLLAPSED;
      let style = this.$refs.root.style;
      style.overflowY = this.getOverflow();
      style.height = collapseHeight;
      style.visibility = 'hidden'; // inert

      this.$emit('update', {
        state: COLLAPSED,
        height: collapseHeight
      });
    },

    setExpanded() {
      if (!this.$refs.root) return;
      this.collapseState = EXPANDED;
      let style = this.$refs.root.style;
      style.overflowY = this.getOverflow();
      style.height = '';
      style.visibility = '';
      this.$emit('update', {
        state: EXPANDED,
        height: this.getElementHeight()
      });
    },

    setCollapsing() {
      if (!this.$refs.root) return;
      this.collapseState = COLLAPSING;
      let height = this.getElementHeight();
      let style = this.$refs.root.style;
      style.overflowY = this.getOverflow();
      style.height = height;
      style.visibility = '';
      this.$emit('update', {
        state: COLLAPSING,
        height
      });
      nextFrame(() => {
        if (!this.$refs.root) return;
        if (this.collapseState !== COLLAPSING) return;
        this.$refs.root.style.height = collapseHeight;
      });
    },

    setExpanding() {
      if (!this.$refs.root) return;
      this.$emit('update', {
        state: EXPANDING,
        height: ''
      });
      this.collapseState = EXPANDING;
      nextFrame(() => {
        if (!this.$refs.root) return;
        if (this.collapseState !== EXPANDING) return;
        let style = this.$refs.root.style;
        style.overflowY = this.getOverflow();
        style.height = this.getElementHeight();
        style.visibility = '';
      });
    },

    getElementHeight() {
      return `${this.$refs.root.scrollHeight}px`;
    },

    getOverflow() {
      return this.collapseState === EXPANDED && this.overflowOnExpanded ? '' : 'hidden';
    },

    onTransitionEnd(event) {
      if (event.propertyName === 'height' && event.target === this.$refs.root) {
        if (this.getElementHeight() === this.$refs.root.style.height) {
          if (this.collapseState === EXPANDING) this.setExpanded();
        } else {
          if (this.collapseState === COLLAPSING) this.setCollapsed();
        }
      }
    }

  }
};function normalizeComponent(template, style, script, scopeId, isFunctionalTemplate, moduleIdentifier /* server only */, shadowMode, createInjector, createInjectorSSR, createInjectorShadow) {
    if (typeof shadowMode !== 'boolean') {
        createInjectorSSR = createInjector;
        createInjector = shadowMode;
        shadowMode = false;
    }
    // Vue.extend constructor export interop.
    const options = typeof script === 'function' ? script.options : script;
    // render functions
    if (template && template.render) {
        options.render = template.render;
        options.staticRenderFns = template.staticRenderFns;
        options._compiled = true;
        // functional template
        if (isFunctionalTemplate) {
            options.functional = true;
        }
    }
    // scopedId
    if (scopeId) {
        options._scopeId = scopeId;
    }
    let hook;
    if (moduleIdentifier) {
        // server build
        hook = function (context) {
            // 2.3 injection
            context =
                context || // cached call
                    (this.$vnode && this.$vnode.ssrContext) || // stateful
                    (this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext); // functional
            // 2.2 with runInNewContext: true
            if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {
                context = __VUE_SSR_CONTEXT__;
            }
            // inject component styles
            if (style) {
                style.call(this, createInjectorSSR(context));
            }
            // register component module identifier for async chunk inference
            if (context && context._registeredComponents) {
                context._registeredComponents.add(moduleIdentifier);
            }
        };
        // used by ssr in case component is cached and beforeCreate
        // never gets called
        options._ssrRegister = hook;
    }
    else if (style) {
        hook = shadowMode
            ? function (context) {
                style.call(this, createInjectorShadow(context, this.$root.$options.shadowRoot));
            }
            : function (context) {
                style.call(this, createInjector(context));
            };
    }
    if (hook) {
        if (options.functional) {
            // register for functional component in vue file
            const originalRender = options.render;
            options.render = function renderWithStyleInjection(h, context) {
                hook.call(context);
                return originalRender(h, context);
            };
        }
        else {
            // inject component registration as beforeCreate hook
            const existing = options.beforeCreate;
            options.beforeCreate = existing ? [].concat(existing, hook) : [hook];
        }
    }
    return script;
}/* script */
const __vue_script__ = script;
/* template */

var __vue_render__ = function () {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c(_vm.tag, {
    ref: "root",
    tag: "component",
    attrs: {
      "data-height-collapsible": "",
      "data-collapse-state": _vm.collapseState
    }
  }, [_vm._t("default", null, {
    "state": _vm.collapseState
  })], 2);
};

var __vue_staticRenderFns__ = [];
/* style */

const __vue_inject_styles__ = undefined;
/* scoped */

const __vue_scope_id__ = undefined;
/* module identifier */

const __vue_module_identifier__ = "data-v-7d12be38";
/* functional template */

const __vue_is_functional_template__ = false;
/* style inject */

/* style inject SSR */

/* style inject shadow dom */

const __vue_component__ = /*#__PURE__*/normalizeComponent({
  render: __vue_render__,
  staticRenderFns: __vue_staticRenderFns__
}, __vue_inject_styles__, __vue_script__, __vue_scope_id__, __vue_is_functional_template__, __vue_module_identifier__, false, undefined, undefined, undefined);

var component$1 = __vue_component__;// Import vue component

// Default export is installable instance of component.
// IIFE injects install function into component, allowing component
// to be registered via Vue.use() as well as Vue.component(),
var component = /*#__PURE__*/(() => {
  // Assign InstallableComponent type
  const installable = component$1; // Attach install function executed by Vue.use()

  installable.install = Vue => {
    Vue.component('VueHeightCollapsible', installable);
  };

  return installable;
})(); // It's possible to expose named exports when writing components that can
// also be used as directives, etc. - eg. import { RollupDemoDirective } from 'rollup-demo';
// export const RollupDemoDirective = directive;
var namedExports=/*#__PURE__*/Object.freeze({__proto__:null,'default': component});// iife/cjs usage extends esm default export - so import it all
// only expose one global var, with named exports exposed as properties of
// that global var (eg. plugin.namedExport)

Object.entries(namedExports).forEach(([exportName, exported]) => {
  if (exportName !== 'default') component[exportName] = exported;
});module.exports=component;