import { Ref } from 'vue';
import type { PropsImgs } from '../types';
export interface UseEasyLightboxOptions {
    /**
     * image src/ImgObj or list of images src/ImgObj
     * imgObj: { src: string, title?: string, alt?: string }
     * @default ''
     */
    imgs: PropsImgs;
    /**
     * initial index of imgList
     * @default 0
     */
    initIndex?: number;
}
export declare const useEasyLightbox: (options?: UseEasyLightboxOptions) => {
    imgsRef: Ref<string | {
        src?: string | undefined;
        title?: string | undefined;
        alt?: string | undefined;
    } | (string | {
        src?: string | undefined;
        title?: string | undefined;
        alt?: string | undefined;
    })[]>;
    indexRef: Ref<number>;
    visibleRef: Ref<boolean>;
    show: (index?: Ref<number> | number | Event) => void;
    onHide: () => void;
    changeIndex: (index?: number) => void;
};
