import * as tippy_js from 'tippy.js';
import { Instance, Props, CreateSingletonInstance, DefaultProps } from 'tippy.js';
import * as vue from 'vue';
import { ToRefs, Ref, ComponentPropsOptions as ComponentPropsOptions$1, EmitsOptions, MethodOptions, DefineComponent as DefineComponent$1, ComponentOptionsMixin, ComputedRef, Directive, App, Plugin as Plugin$1 } from 'vue';
import * as _popperjs_core from '@popperjs/core';
import { ComponentPropsOptions, ExtractPropTypes, PropType } from '@vue/runtime-core';

declare const commonEmits: {
    mount: (instance: Instance) => boolean;
    show: (instance: Instance) => boolean;
    shown: (instance: Instance) => boolean;
    hidden: (instance: Instance) => boolean;
    hide: (instance: Instance) => boolean;
    trigger: (instance: Instance, event: Event) => boolean;
    untrigger: (instance: Instance, event: Event) => boolean;
};
declare type Plugin<P extends ComponentPropsOptions = {}> = {
    props: P;
    setup?(props: Required<ToRefs<ExtractPropTypes<P>>> & Record<string, Ref<unknown>>, tip: Ref<Instance | undefined>): void;
    build?(props: Required<ToRefs<ExtractPropTypes<P>>> & Record<string, Ref<unknown>>, options: Partial<Props>): void;
};
/**
 * Infers the plugin type to provide type hinting for the parameter
 */
declare function inferPlugin<P extends ComponentPropsOptions>(plugin: Plugin<P>): Plugin<P>;
/**
 * Creates a plugin that exposes a Tippy.js option as a Vue prop
 * @param name The name of the Tippy.js option
 * @param type The type of the Vue property (e.g. `String`, `Boolean`, etc.)
 * @param def The default value, if any
 */
declare function optionPlugin<T extends keyof Props>(name: T, type?: PropType<any>, def?: Props[T]): Plugin<Record<T, {
    type: PropType<Props[T]>;
    required: false;
}>>;

declare type UnionToIntersection<U> = (U extends any ? (k: U) => void : never) extends ((k: infer I) => void) ? I : never;
declare type ExtractPluginProps<P extends Plugin> = UnionToIntersection<(P extends Plugin<infer I> ? I : never)>;
declare type DefineComponent<Props extends ComponentPropsOptions$1, Emits extends EmitsOptions, Data, Methods extends MethodOptions> = DefineComponent$1<//
Props, Data, unknown, {}, Methods, ComponentOptionsMixin, ComponentOptionsMixin, Emits>;

declare const defaultTippyProps: (Plugin<{
    visible: {
        type: BooleanConstructor;
        required: false;
    };
}> | Plugin<{
    enabled: {
        type: BooleanConstructor;
        required: false;
        default: boolean;
    };
}> | Plugin<Record<"placement", {
    type: PropType<_popperjs_core.Placement>;
    required: false;
}>> | Plugin<{
    onBody: {
        type: BooleanConstructor;
        required: false;
    };
}> | Plugin<Record<"interactive", {
    type: PropType<boolean>;
    required: false;
}>> | Plugin<{
    trigger: {
        type: StringConstructor;
        required: false;
    };
}> | Plugin<Record<"hideOnClick", {
    type: PropType<boolean | "toggle">;
    required: false;
}>> | Plugin<{
    delay: {
        type: PropType<number | `${number}` | [number | null, number | null] | `${number},${number}` | `${number},-` | `-,${number}` | "-,-">;
        required: boolean;
        validator(value: unknown): boolean;
    };
}> | Plugin<{
    extra: {
        type: PropType<Partial<Props>>;
        required: false;
    };
}>)[];
declare const baseProps$1: {
    /**
     * The v-tippy target name. Defaults to `""` (the default name used by `v-tippy`)
     */
    target: {
        type: PropType<string>;
        required: boolean;
        default: string;
    };
    /**
     * Whether to perform a deep search for targets (using querySelector) or to only search for direct siblings.
     */
    deepSearch: {
        type: BooleanConstructor;
        required: boolean;
        default: boolean;
    };
    singleton: {
        type: PropType<string | boolean | null>;
        required: boolean;
        default: null;
    };
    /**
     * Whether to eagerly render the content or only render when the tooltip is visible
     */
    eager: {
        type: BooleanConstructor;
        required: boolean;
        default: boolean;
    };
};
declare type TippyComponentType<Plugins extends Plugin[] = [], DefaultPlugins extends Plugin[] = typeof defaultTippyProps> = DefineComponent<//
//
typeof baseProps$1 & ExtractPluginProps<Plugins[number] | DefaultPlugins[number]>, typeof commonEmits & {
    attach: (instance: Instance) => true;
}, {
    tip: Ref<Instance | undefined>;
    tippyOptions: ComputedRef<Partial<Props>>;
}, {
    attach(): void;
}>;
declare function createTippyComponent<P extends Plugin[]>(...plugins: P): TippyComponentType<P>;

declare type VueSingleton = {
    add(instance: Instance): void;
    remove(instance: Instance): void;
};
declare global {
    interface Element {
        _tippySingleton?: VueSingleton;
    }
}
declare const defaultTippySingletonProps: (Plugin<{
    enabled: {
        type: BooleanConstructor;
        required: false;
        default: boolean;
    };
}> | Plugin<Record<"placement", {
    type: PropType<_popperjs_core.Placement>;
    required: false;
}>> | Plugin<{
    onBody: {
        type: BooleanConstructor;
        required: false;
    };
}> | Plugin<Record<"interactive", {
    type: PropType<boolean>;
    required: false;
}>> | Plugin<{
    trigger: {
        type: StringConstructor;
        required: false;
    };
}> | Plugin<Record<"hideOnClick", {
    type: PropType<boolean | "toggle">;
    required: false;
}>> | Plugin<{
    delay: {
        type: PropType<number | `${number}` | [number | null, number | null] | `${number},${number}` | `${number},-` | `-,${number}` | "-,-">;
        required: boolean;
        validator(value: unknown): boolean;
    };
}> | Plugin<{
    extra: {
        type: PropType<Partial<tippy_js.Props>>;
        required: false;
    };
}> | Plugin<{
    overrides: {
        type: PropType<(keyof tippy_js.Props)[]>;
        required: false;
    };
}> | Plugin<Record<"moveTransition", {
    type: PropType<string>;
    required: false;
}>>)[];
declare const baseProps: {
    /**
     * The singleton name. Defaults to `""` (the default name used by `<tippy singleton>`)
     */
    name: {
        type: PropType<string>;
        required: boolean;
        default: string;
    };
};
declare type TippySingletonComponentType<Plugins extends Plugin[] = [], DefaultPlugins extends Plugin[] = typeof defaultTippySingletonProps> = DefineComponent<//
//
typeof baseProps & ExtractPluginProps<Plugins[number] | DefaultPlugins[number]>, typeof commonEmits & {
    add: (instance: Instance) => true;
    remove: (instance: Instance) => true;
}, {
    instances: Ref<Instance[]>;
    singleton: Ref<CreateSingletonInstance>;
}, {
    add(instance: Instance): void;
    remove(instance: Instance): void;
}>;
declare function createTippySingletonComponent<P extends Plugin[]>(...plugins: P): TippySingletonComponentType<P>;

declare const _mode: unique symbol;
declare type VTippyMode = 'inline' | 'target';
declare const _tippy: unique symbol;
declare global {
    interface HTMLElement {
        [_mode]?: VTippyMode;
        [_tippy]?: Instance;
    }
}
declare const TippyDirective: Directive<HTMLElement, string | Partial<Props> | undefined>;

/**
 * Extra options for tippy.js
 */
declare const extra: Plugin<{
    extra: {
        type: PropType<Partial<Props>>;
        required: false;
    };
}>;
/**
 * Whether the tooltip should be enabled
 */
declare const enabled: Plugin<{
    enabled: {
        type: BooleanConstructor;
        required: false;
        default: boolean;
    };
}>;
/**
 * Where to place the tooltip relative to the target element
 */
declare const placement: Plugin<Record<"placement", {
    type: PropType<_popperjs_core.Placement>;
    required: false;
}>>;
/**
 * Whether the tippy should be interactive. You don't need to specify a value for this property, its presence is
 * sufficient (e.g. `<tippy interactive>`).
 *
 * This is a shorthand for `interactive: true` in the `extra` property.
 */
declare const interactive: Plugin<Record<"interactive", {
    type: PropType<boolean>;
    required: false;
}>>;
/**
 * Whether to hide the tooltip when the target element is clicked. Defaults to false when using the `'manual'`
 * trigger, otherwise defaults to true.
 */
declare const hideOnClick: Plugin<Record<"hideOnClick", {
    type: PropType<boolean | "toggle">;
    required: false;
}>>;
/**
 * Whether the tippy should *always* be appended to the `<body>`. You don't need to specify a value for this property,
 * its presence is sufficient (e.g. `<tippy on-body>`).
 *
 * Normally, tooltips will be appended to the document body element, *however*, interactive elements are appended
 * adjacent to their trigger, in the interest of maintaining keyboard focus order.
 * [more info](https://atomiks.github.io/tippyjs/v6/accessibility/#clipping-issues)
 *
 * This can cause zIndex issues, so sometimes it's necessary to put an interactive tooltip on the body element.
 *
 * This is a shorthand for `appendTo: () => document.body` in the `extra` property. (Note that you can't access
 * `document` directly in a vue template, so you would have to use a computed property if you wanted to set this in
 * `extra` yourself.
 */
declare const onBody: Plugin<{
    onBody: {
        type: BooleanConstructor;
        required: false;
    };
}>;
/**
 * The events that trigger the tooltip. Setting the trigger key in `extra` will override this property.
 */
declare const trigger: Plugin<{
    trigger: {
        type: StringConstructor;
        required: false;
    };
}>;
declare type DelayType = number | [number | null, number | null] | `${number}` | `${number | '-'},${number | '-'}`;
/**
 * The delay when showing or hiding the tooltip. One of four formats:
 * - A number (or number string) representing the delay in milliseconds
 * - A string consisting of two comma-separated elements representing the show and hide delays, each of which is
 *   either a number or a '-'
 * - An array of two `number | null` elements
 */
declare const delay: Plugin<{
    delay: {
        type: PropType<DelayType>;
        required: boolean;
        validator(value: unknown): boolean;
    };
}>;
/**
 * Only used when using the manual trigger. To show/hide when using another trigger, use `tippy().show()` and
 * `tippy().hide()`
 */
declare const visible: Plugin<{
    visible: {
        type: BooleanConstructor;
        required: false;
    };
}>;
/**
 * Tippy.js options that should be overridden by the individual instances.
 */
declare const overrides: Plugin<{
    overrides: {
        type: PropType<(keyof Props)[]>;
        required: false;
    };
}>;
/**
 * The CSS transition to use when moving between instances within the singleton
 */
declare const moveTransition: Plugin<Record<"moveTransition", {
    type: PropType<string>;
    required: false;
}>>;

declare const builtin_extra: typeof extra;
declare const builtin_enabled: typeof enabled;
declare const builtin_placement: typeof placement;
declare const builtin_interactive: typeof interactive;
declare const builtin_hideOnClick: typeof hideOnClick;
declare const builtin_onBody: typeof onBody;
declare const builtin_trigger: typeof trigger;
declare const builtin_delay: typeof delay;
declare const builtin_visible: typeof visible;
declare const builtin_overrides: typeof overrides;
declare const builtin_moveTransition: typeof moveTransition;
declare namespace builtin {
  export {
    builtin_extra as extra,
    builtin_enabled as enabled,
    builtin_placement as placement,
    builtin_interactive as interactive,
    builtin_hideOnClick as hideOnClick,
    builtin_onBody as onBody,
    builtin_trigger as trigger,
    builtin_delay as delay,
    builtin_visible as visible,
    builtin_overrides as overrides,
    builtin_moveTransition as moveTransition,
  };
}

declare function install(app: App, options?: {
    tippyDefaults?: Partial<DefaultProps>;
    tippyProps?: Plugin[];
    tippySingletonProps?: Plugin[];
}): void;
declare const TippyPlugin: Plugin$1;
declare const Tippy: TippyComponentType<(Plugin<{
    visible: {
        type: BooleanConstructor;
        required: false;
    };
}> | Plugin<{
    enabled: {
        type: BooleanConstructor;
        required: false;
        default: boolean;
    };
}> | Plugin<Record<"placement", {
    type: vue.PropType<_popperjs_core.Placement>;
    required: false;
}>> | Plugin<{
    onBody: {
        type: BooleanConstructor;
        required: false;
    };
}> | Plugin<Record<"interactive", {
    type: vue.PropType<boolean>;
    required: false;
}>> | Plugin<{
    trigger: {
        type: StringConstructor;
        required: false;
    };
}> | Plugin<Record<"hideOnClick", {
    type: vue.PropType<boolean | "toggle">;
    required: false;
}>> | Plugin<{
    delay: {
        type: vue.PropType<number | `${number}` | [number | null, number | null] | `${number},${number}` | `${number},-` | `-,${number}` | "-,-">;
        required: boolean;
        validator(value: unknown): boolean;
    };
}> | Plugin<{
    extra: {
        type: vue.PropType<Partial<tippy_js.Props>>;
        required: false;
    };
}>)[], (Plugin<{
    visible: {
        type: BooleanConstructor;
        required: false;
    };
}> | Plugin<{
    enabled: {
        type: BooleanConstructor;
        required: false;
        default: boolean;
    };
}> | Plugin<Record<"placement", {
    type: vue.PropType<_popperjs_core.Placement>;
    required: false;
}>> | Plugin<{
    onBody: {
        type: BooleanConstructor;
        required: false;
    };
}> | Plugin<Record<"interactive", {
    type: vue.PropType<boolean>;
    required: false;
}>> | Plugin<{
    trigger: {
        type: StringConstructor;
        required: false;
    };
}> | Plugin<Record<"hideOnClick", {
    type: vue.PropType<boolean | "toggle">;
    required: false;
}>> | Plugin<{
    delay: {
        type: vue.PropType<number | `${number}` | [number | null, number | null] | `${number},${number}` | `${number},-` | `-,${number}` | "-,-">;
        required: boolean;
        validator(value: unknown): boolean;
    };
}> | Plugin<{
    extra: {
        type: vue.PropType<Partial<tippy_js.Props>>;
        required: false;
    };
}>)[]>;
declare const TippySingleton: TippySingletonComponentType<(Plugin<{
    enabled: {
        type: BooleanConstructor;
        required: false;
        default: boolean;
    };
}> | Plugin<Record<"placement", {
    type: vue.PropType<_popperjs_core.Placement>;
    required: false;
}>> | Plugin<{
    onBody: {
        type: BooleanConstructor;
        required: false;
    };
}> | Plugin<Record<"interactive", {
    type: vue.PropType<boolean>;
    required: false;
}>> | Plugin<{
    trigger: {
        type: StringConstructor;
        required: false;
    };
}> | Plugin<Record<"hideOnClick", {
    type: vue.PropType<boolean | "toggle">;
    required: false;
}>> | Plugin<{
    delay: {
        type: vue.PropType<number | `${number}` | [number | null, number | null] | `${number},${number}` | `${number},-` | `-,${number}` | "-,-">;
        required: boolean;
        validator(value: unknown): boolean;
    };
}> | Plugin<{
    extra: {
        type: vue.PropType<Partial<tippy_js.Props>>;
        required: false;
    };
}> | Plugin<{
    overrides: {
        type: vue.PropType<(keyof tippy_js.Props)[]>;
        required: false;
    };
}> | Plugin<Record<"moveTransition", {
    type: vue.PropType<string>;
    required: false;
}>>)[], (Plugin<{
    enabled: {
        type: BooleanConstructor;
        required: false;
        default: boolean;
    };
}> | Plugin<Record<"placement", {
    type: vue.PropType<_popperjs_core.Placement>;
    required: false;
}>> | Plugin<{
    onBody: {
        type: BooleanConstructor;
        required: false;
    };
}> | Plugin<Record<"interactive", {
    type: vue.PropType<boolean>;
    required: false;
}>> | Plugin<{
    trigger: {
        type: StringConstructor;
        required: false;
    };
}> | Plugin<Record<"hideOnClick", {
    type: vue.PropType<boolean | "toggle">;
    required: false;
}>> | Plugin<{
    delay: {
        type: vue.PropType<number | `${number}` | [number | null, number | null] | `${number},${number}` | `${number},-` | `-,${number}` | "-,-">;
        required: boolean;
        validator(value: unknown): boolean;
    };
}> | Plugin<{
    extra: {
        type: vue.PropType<Partial<tippy_js.Props>>;
        required: false;
    };
}> | Plugin<{
    overrides: {
        type: vue.PropType<(keyof tippy_js.Props)[]>;
        required: false;
    };
}> | Plugin<Record<"moveTransition", {
    type: vue.PropType<string>;
    required: false;
}>>)[]>;

export { Plugin, Tippy, TippyComponentType, TippyDirective, TippyPlugin, TippySingleton, TippySingletonComponentType, createTippyComponent, createTippySingletonComponent, defaultTippyProps, defaultTippySingletonProps, inferPlugin, install, optionPlugin, builtin as props };
