<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Add profit_type to existing profit_ranges. All current ranges are treated as absolute.
     * New structure per range: min_cost, max_cost, profit, profit_type ('absolute' | 'percentage')
     */
    public function up(): void
    {
        $rows = DB::table('collection_cost_configurations')->get();

        foreach ($rows as $row) {
            $ranges = json_decode($row->profit_ranges, true);
            if (!is_array($ranges)) {
                continue;
            }

            $updated = false;
            foreach ($ranges as &$range) {
                if (!is_array($range)) {
                    continue;
                }
                if (!isset($range['profit_type'])) {
                    $range['profit_type'] = 'absolute';
                    $updated = true;
                }
            }

            if ($updated) {
                DB::table('collection_cost_configurations')
                    ->where('id', $row->id)
                    ->update(['profit_ranges' => json_encode($ranges)]);
            }
        }
    }

    /**
     * Reverse: remove profit_type from ranges (optional, for rollback).
     */
    public function down(): void
    {
        $rows = DB::table('collection_cost_configurations')->get();

        foreach ($rows as $row) {
            $ranges = json_decode($row->profit_ranges, true);
            if (!is_array($ranges)) {
                continue;
            }

            $updated = false;
            foreach ($ranges as &$range) {
                if (!is_array($range)) {
                    continue;
                }
                if (array_key_exists('profit_type', $range)) {
                    unset($range['profit_type']);
                    $updated = true;
                }
            }

            if ($updated) {
                DB::table('collection_cost_configurations')
                    ->where('id', $row->id)
                    ->update(['profit_ranges' => json_encode($ranges)]);
            }
        }
    }
};
