<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('gold_price_weight_rules', function (Blueprint $table) {
            // Check if column exists before adding
            if (!Schema::hasColumn('gold_price_weight_rules', 'collection_id')) {
                $table->string('collection_id')->nullable()->after('id')->comment('Shopify collection ID');
            }
        });

        // Drop old index if it exists (using raw SQL to check)
        $indexExists = DB::select("SHOW INDEX FROM gold_price_weight_rules WHERE Key_name = 'gold_price_weight_rules_min_weight_max_weight_index'");
        if (!empty($indexExists)) {
            DB::statement('ALTER TABLE gold_price_weight_rules DROP INDEX gold_price_weight_rules_min_weight_max_weight_index');
        }

        // Add new index if it doesn't exist
        $newIndexExists = DB::select("SHOW INDEX FROM gold_price_weight_rules WHERE Key_name = 'gpwr_collection_weight_idx'");
        if (empty($newIndexExists)) {
            Schema::table('gold_price_weight_rules', function (Blueprint $table) {
                $table->index(['collection_id', 'min_weight', 'max_weight'], 'gpwr_collection_weight_idx');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('gold_price_weight_rules', function (Blueprint $table) {
            $table->dropIndex('gpwr_collection_weight_idx');
            $table->index(['min_weight', 'max_weight']);
            $table->dropColumn('collection_id');
        });
    }
};
