<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('gold_price_weight_rules', function (Blueprint $table) {
            $table->id();
            $table->decimal('min_weight', 10, 3)->comment('Minimum weight in grams');
            $table->decimal('max_weight', 10, 3)->comment('Maximum weight in grams');
            $table->decimal('fee_10k', 10, 2)->default(0)->comment('Fee for 10k gold in USD');
            $table->decimal('fee_14k', 10, 2)->default(0)->comment('Fee for 14k gold in USD');
            $table->integer('order')->default(0)->comment('Order for sorting rules');
            $table->timestamps();

            // Index for efficient range queries
            $table->index(['min_weight', 'max_weight']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('gold_price_weight_rules');
    }
};
