<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('collection_cost_price_logs', function (Blueprint $table) {
            $table->id();
            $table->string('collection_id'); // ID de la colección en Shopify
            $table->string('collection_title'); // Título de la colección
            $table->enum('status', ['success', 'failed'])->default('success');
            $table->timestamp('executed_at'); // Fecha y hora de ejecución
            $table->integer('total_variants')->default(0); // Total de variantes procesadas
            $table->integer('updated_variants')->default(0); // Variantes actualizadas exitosamente
            $table->integer('errors')->default(0); // Número de errores
            $table->text('error_message')->nullable(); // Mensaje de error si falló
            $table->boolean('demo_mode')->default(false); // Si fue ejecutado en modo test
            $table->timestamps();
            
            // Índices para búsquedas rápidas
            $table->index('collection_id');
            $table->index('executed_at');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('collection_cost_price_logs');
    }
};
