<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('collection_cost_configurations', function (Blueprint $table) {
            $table->id();
            $table->string('collection_id')->unique(); // ID de la colección en Shopify
            $table->string('collection_title'); // Título de la colección
            $table->json('profit_ranges'); // Array de rangos de profit
            $table->json('expenses'); // Objeto con los gastos configurados
            $table->timestamps();
            
            // Índice para búsquedas rápidas por collection_id
            $table->index('collection_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('collection_cost_configurations');
    }
};
