<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('gold_price_log_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('gold_price_log_id')->constrained()->onDelete('cascade');
            $table->string('collection_name');
            $table->string('collection_id')->nullable();

            // Prices used
            $table->decimal('price_10k', 15, 6)->nullable();
            $table->decimal('price_14k', 15, 6)->nullable();

            // Statistics
            $table->integer('products_processed')->default(0);
            $table->integer('products_updated_10k')->default(0);
            $table->integer('products_updated_14k')->default(0);
            $table->integer('errors_10k')->default(0);
            $table->integer('errors_14k')->default(0);

            $table->timestamps();

            // Indexes
            $table->index('gold_price_log_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('gold_price_log_details');
    }
};
