<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('gold_price_error_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('gold_price_log_id')->constrained()->onDelete('cascade');
            $table->string('material_type'); // '10k' or '14k'
            $table->string('product_id')->nullable();
            $table->string('product_title')->nullable();
            $table->string('variant_id')->nullable();
            $table->string('variant_title')->nullable();
            $table->text('error_message');
            $table->text('error_trace')->nullable();
            $table->timestamps();

            // Indexes
            $table->index('gold_price_log_id');
            $table->index('material_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('gold_price_error_logs');
    }
};
