<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('gold_price_logs', function (Blueprint $table) {
            $table->id();
            $table->enum('execution_type', ['automatic', 'manual'])->default('automatic');
            $table->string('collection_name')->nullable();
            $table->string('collection_id')->nullable();

            // Summary
            $table->integer('total_products_processed')->default(0);
            $table->integer('total_10k_updated')->default(0);
            $table->integer('total_14k_updated')->default(0);
            $table->integer('total_10k_errors')->default(0);
            $table->integer('total_14k_errors')->default(0);
            $table->decimal('gold_price_per_gram', 15, 6)->nullable();

            // Status
            $table->enum('status', ['success', 'partial_success', 'failed'])->default('success');
            $table->text('summary_message')->nullable();
            $table->text('error_details')->nullable();

            // Metadata
            $table->timestamp('started_at')->nullable();
            $table->timestamp('completed_at')->nullable();
            $table->integer('duration_seconds')->nullable();

            $table->timestamps();

            // Indexes
            $table->index('execution_type');
            $table->index('created_at');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('gold_price_logs');
    }
};
