<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Model;


class WizardContract extends Model
{


    protected $fillable = [
        'id',
        'contract',
        'type',
        'name',
        'owner',
        'owner_address',
        'owner_phone',
        'owner_email',
        'first_name',
        'c_first_name',
        'last_name',
        'c_last_name',
        'c_driver_license',
        'c_driver_license_dob',
        'initial',
        'c_initial',
        'signature',
        'c_signature',
        'email',
        'c_email',
        'phone',
        'c_phone',
        'address_label1',
        'c_address_label1',
        'address_label2',
        'c_address_label2',
        'ip',
        'c_ip',
        'city',
        'c_city',
        'country',
        'c_country',
        'state',
        'c_state',
        'zip',
        'c_zip',
        'notes',
        'order_id',
        'amount',
        'payment_method',
        'item',
        'items',
        'card_type',
        'card_holder_name',
        'c_card_holder_name',
        'card_ended_number',
        'c_card_ended_number',
        'card_expiration_date',
        'c_card_expiration_date',
        'c_identity_doc',
        'c_selfie_doc',
        'c_signature_doc',
        'c_creditcard_doc',
        'c_creditcardb_doc',
        'source',
        'contract_pdf',
        'invoice_number',
        'status',
        'token',
        'terms',
        'sendvia',
        'signed_at',
        'expired_notification',
        'resend_doc_status',
        'resend_doc_status_updated'

    ];
    public function getAddressTiraAttribute()
    {
        $tira = "";
        $tira .= ($this->address_label1) ? $this->address_label1 : "";
        $tira .= ($this->address_label2) ? ", " . $this->address_label2 : "";
        $tira .= ($this->city) ? ", " . $this->city : "";
        $tira .= ($this->state) ? ", " . $this->state : "";
        $tira .= ($this->zip) ? ", " . $this->zip : "";
        return $tira;
    }
    protected $casts = [
        'items' => 'array'
    ];
}
