<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GoldPriceLogDetail extends Model
{
    use HasFactory;

    protected $fillable = [
        'gold_price_log_id',
        'collection_name',
        'collection_id',
        'price_10k',
        'price_14k',
        'products_processed',
        'products_updated_10k',
        'products_updated_14k',
        'errors_10k',
        'errors_14k',
    ];

    protected $casts = [
        'price_10k' => 'decimal:6',
        'price_14k' => 'decimal:6',
    ];

    public function goldPriceLog()
    {
        return $this->belongsTo(GoldPriceLog::class);
    }
}
