<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GoldPriceLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'execution_type',
        'collection_name',
        'collection_id',
        'total_products_processed',
        'total_10k_updated',
        'total_14k_updated',
        'total_10k_errors',
        'total_14k_errors',
        'gold_price_per_gram',
        'status',
        'summary_message',
        'error_details',
        'started_at',
        'completed_at',
        'duration_seconds',
    ];

    protected $casts = [
        'gold_price_per_gram' => 'decimal:6',
        'started_at' => 'datetime',
        'completed_at' => 'datetime',
    ];

    public function errorLogs()
    {
        return $this->hasMany(GoldPriceErrorLog::class);
    }

    public function details()
    {
        return $this->hasMany(GoldPriceLogDetail::class);
    }
}
