<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GoldPriceErrorLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'gold_price_log_id',
        'material_type',
        'product_id',
        'product_title',
        'variant_id',
        'variant_title',
        'error_message',
        'error_trace',
    ];

    public function goldPriceLog()
    {
        return $this->belongsTo(GoldPriceLog::class);
    }
}
