<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Configuration extends Model
{
    use HasFactory;

    protected $fillable = [
        'auto_10k',
        'auto_14k',
        'collections',
        'rounding_option',
        'compare_price_config',
    ];

    protected $casts = [
        'auto_10k' => 'boolean',
        'auto_14k' => 'boolean',
        'collections' => 'array',
        'compare_price_config' => 'array',
    ];

    /**
     * Get the singleton configuration instance
     */
    public static function getInstance()
    {
        return static::firstOrCreate(['id' => 1]);
    }
}
