<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CollectionCostPriceLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'collection_id',
        'collection_title',
        'status',
        'executed_at',
        'total_variants',
        'updated_variants',
        'errors',
        'error_message',
        'demo_mode',
    ];

    protected $casts = [
        'executed_at' => 'datetime',
        'total_variants' => 'integer',
        'updated_variants' => 'integer',
        'errors' => 'integer',
        'demo_mode' => 'boolean',
    ];

    /**
     * Get the latest logs ordered by executed_at descending
     *
     * @param int $limit
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public static function getLatest($limit = 5)
    {
        return static::orderBy('executed_at', 'desc')
            ->limit($limit)
            ->get();
    }
}
