<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CollectionCostConfiguration extends Model
{
    use HasFactory;

    protected $fillable = [
        'collection_id',
        'collection_title',
        'profit_ranges',
        'expenses',
        'rounding_option',
    ];

    protected $casts = [
        'profit_ranges' => 'array',
        'expenses' => 'array',
    ];

    /**
     * Find or create configuration for a collection
     *
     * @param string $collectionId
     * @param string $collectionTitle
     * @return CollectionCostConfiguration
     */
    public static function findOrCreateForCollection(string $collectionId, string $collectionTitle): self
    {
        return static::firstOrCreate(
            ['collection_id' => $collectionId],
            [
                'collection_title' => $collectionTitle,
                'profit_ranges' => [],
                'expenses' => [],
                'rounding_option' => 'default',
            ]
        );
    }

    /**
     * Get configuration for a collection
     *
     * @param string $collectionId
     * @return CollectionCostConfiguration|null
     */
    public static function getForCollection(string $collectionId): ?self
    {
        return static::where('collection_id', $collectionId)->first();
    }
}
