<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class GoldPriceUpdateNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $executionType;
    public $collections;
    public $goldPrice;

    /**
     * Create a new message instance.
     */
    public function __construct($executionType, $collections, $goldPrice)
    {
        $this->executionType = $executionType;
        $this->collections = $collections;
        $this->goldPrice = $goldPrice;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        $subject = $this->executionType === 'automatic'
            ? 'Automatic Gold Price Update Complete'
            : 'Manual Gold Price Update Complete';

        return new Envelope(
            subject: $subject,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.gold-price-update',
            with: [
                'executionType' => $this->executionType,
                'collections' => $this->collections,
                'goldPrice' => $this->goldPrice,
            ]
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
