<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateConfigurationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'auto_10k' => ['required', 'boolean'],
            'auto_14k' => ['required', 'boolean'],
            'collections' => ['nullable', 'array'],
            'collections.*.name' => ['required', 'string'],
            'collections.*.enabled' => ['required', 'boolean'],
            'collections.*.fee_10k' => ['nullable', 'numeric', 'min:0'],
            'collections.*.fee_14k' => ['nullable', 'numeric', 'min:0'],
            'rounding_option' => ['nullable', 'string', 'in:default,round_to_99_99,round_to_hundreds,round_to_hundreds_minus_one'],
            'compare_price_config' => ['nullable', 'array'],
            'compare_price_config.calculation_method' => ['required_with:compare_price_config', 'string', 'in:compare_price,sale_price'],
            'compare_price_config.rounding_option' => ['required_with:compare_price_config', 'string', 'in:default,round_to_99_99,round_to_hundreds,round_to_hundreds_minus_one'],
            'compare_price_config.action' => ['required_if:compare_price_config.calculation_method,compare_price', 'nullable', 'string', 'in:Increment,Decrement'],
            'compare_price_config.operation' => ['required_if:compare_price_config.calculation_method,compare_price', 'nullable', 'string', 'in:Percent,Value'],
            'compare_price_config.price' => ['required_if:compare_price_config.calculation_method,compare_price', 'nullable', 'numeric', 'min:0'],
            'compare_price_config.calculation_type' => ['required_if:compare_price_config.calculation_method,sale_price', 'nullable', 'string', 'in:fixed,percentage,discount_based'],
            'compare_price_config.amount' => ['required_if:compare_price_config.calculation_method,sale_price', 'nullable', 'numeric', 'min:0'],
        ];
    }
}
