<?php

// App\Http\Middleware\HandleInertiaRequests.php

namespace App\Http\Middleware;

use Illuminate\Http\Request;
use Inertia\Middleware;

class HandleInertiaRequests extends Middleware
{
    protected $rootView = 'app'; // La vista principal de tu aplicación

    public function share(Request $request): array
    {
        return array_merge(parent::share($request), [
            // Puedes compartir datos globales con las vistas Inertia aquí
            'auth' => [
                'user' => $request->user(),
            ],
        ]);
    }
}
