<?php

namespace App\Http\Controllers;

use App\Actions\GetMaterialDataByCollectionAction;
use App\Actions\ListShopifyCollectionsAction;
use App\Actions\ListShopifyProductsAction;
use App\Actions\ListShopifyVariantsAction;
use App\Actions\UpdateShopifyVariantPriceActionByMaterial;
use App\Models\Configuration;
use App\Models\GoldPrice;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Inertia\Inertia;

class ShopifyController extends Controller
{
    //
    public function listProducts()
    {
        // Get all collections from configuration (including disabled ones)
        $config = Configuration::getInstance();
        $configuredCollections = $config->collections ?? [];

        $allCollections = [];

        // Fetch each collection from Shopify
        foreach ($configuredCollections as $collectionConfig) {
            $collectionName = $collectionConfig['name'];
            $collectionData = (new ListShopifyCollectionsAction())($collectionName);

            if (!empty($collectionData['collections'])) {
                // Get the first collection (there should only be one with that name)
                $collection = $collectionData['collections'][0];

                // Add the enabled status to the collection
                if (is_array($collection)) {
                    $collection['enabled'] = $collectionConfig['enabled'] ?? false;
                } else {
                    $collection->enabled = $collectionConfig['enabled'] ?? false;
                }

                $allCollections[] = $collection;
            }
        }

        // Obtener el último precio del oro
        $latestGoldPrice = GoldPrice::latest('created_at')->first();
        $goldPricePerTroyOunce = 0;
        $goldPricePerGram = 0;

        if ($latestGoldPrice) {
            $goldPricePerTroyOunce = $latestGoldPrice->price;
            // 1 onza troy = 31.1035 gramos
            $goldPricePerGram = $goldPricePerTroyOunce / 31.1035;
        }

        return Inertia::render('price', [
            "collections" => $allCollections,
            "total" => count($allCollections),
            "goldPrice" => [
                "perTroyOunce" => $goldPricePerTroyOunce,
                "perGram" => $goldPricePerGram,
                "timestamp" => $latestGoldPrice ? $latestGoldPrice->created_at : null
            ]
        ]);
    }
    public function getMaterialData(Request $request)
    {
        $collection_id = $request->input('collection_id');

        $result = (new GetMaterialDataByCollectionAction())($collection_id);

        $response = [
            'status' => 200,
            'message' => 'Material data loaded successfully',
            'data' => $result,
        ];

        return response()->json($response, $response['status']);
    }

    public function listVariants(Request $request)
    {
        $id = $request->input('id');
        $variants = (new ListShopifyVariantsAction())($id);

        $response = [
            'status' => 200,
            'message' => 'Inavlid load price',
            'data' => $variants,
        ];

        return response()->json($response, $response['status']);
    }

    public function updateVariants(Request $request)
    {
        $result = (new UpdateShopifyVariantPriceActionByMaterial())($request);

        $response = [
            'status' => 200,
            'message' => 'Update variants result',
            'data' => $result,
        ];

        return response()->json($response, $response['status']);
    }
}
