<?php

namespace App\Http\Controllers;

use App\Actions\ListShopifyCollectionsAction;
use App\Actions\UpdateShopifyCollectionReferencePrice;
use App\Actions\UpdateShopifyCollectionReferencePriceFromSale;
use App\Actions\UpdateShopifyCollectionCostPrice;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Inertia\Inertia;

class ShopifyComparePriceController extends Controller
{
    //
    public function listProducts()
    {
        $data = (new ListShopifyCollectionsAction())();


        return Inertia::render('compare-price', ["collections" => $data["collections"], "total" => $data["total"]]);
    }

    public function updatePrice(Request $request)
    {

        $result = (new UpdateShopifyCollectionReferencePrice())($request);

        $response = [
            'status' => 200,
            'message' => 'Update collection result',
            'data' => $result,
        ];

        return response()->json($response, $response['status']);
    }

    public function updatePriceFromSale(Request $request)
    {
        try {
            $result = (new UpdateShopifyCollectionReferencePriceFromSale())($request);

            $response = [
                'status' => 200,
                'message' => 'Update collection result from sale price',
                'data' => $result,
            ];

            return response()->json($response, $response['status']);
        } catch (\Throwable $th) {
            Log::error("Failed to update price from sale", [
                'error' => $th->getMessage(),
                'trace' => $th->getTraceAsString()
            ]);

            return response()->json([
                'status' => 500,
                'message' => 'Operation failed: ' . $th->getMessage(),
                'data' => null
            ], 500);
        }
    }

    /**
     * Get products from a collection
     */
    public function getCollectionProducts(Request $request)
    {
        $collectionId = $request->query('collection_id');

        if (!$collectionId) {
            return response()->json([
                'status' => 400,
                'message' => 'Collection ID is required',
                'data' => null,
            ], 400);
        }

        try {
            $action = new UpdateShopifyCollectionCostPrice();
            $shopifyData = $action->fetchCollectionData($collectionId);
            
            // Extract products with id and title only
            $products = array_map(function ($item) {
                return [
                    'id' => $item['node']['id'],
                    'title' => $item['node']['title']
                ];
            }, $shopifyData['products']);

            return response()->json([
                'status' => 200,
                'message' => 'Products retrieved successfully',
                'data' => $products,
            ], 200);
        } catch (\Throwable $th) {
            Log::error("Failed to get collection products", [
                'collection_id' => $collectionId,
                'error' => $th->getMessage()
            ]);

            return response()->json([
                'status' => 500,
                'message' => 'Failed to get products: ' . $th->getMessage(),
                'data' => null,
            ], 500);
        }
    }
}
