<?php

namespace App\Http\Controllers;

use App\Models\GoldPriceLog;
use Illuminate\Http\Request;
use Inertia\Inertia;

class GoldPriceLogsController extends Controller
{
    public function index()
    {
        // Get only the latest log for the simplified view
        $log = GoldPriceLog::with(['errorLogs', 'details'])
            ->orderBy('created_at', 'desc')
            ->first();

        return Inertia::render('gold-price-logs', [
            'log' => $log
        ]);
    }

    public function show($id)
    {
        $log = GoldPriceLog::with(['errorLogs', 'details'])->findOrFail($id);

        return Inertia::render('gold-price-log-detail', [
            'log' => $log
        ]);
    }

    public function latest()
    {
        $latest = GoldPriceLog::with('errorLogs')
            ->orderBy('created_at', 'desc')
            ->first();

        return Inertia::render('gold-price-log-latest', [
            'log' => $latest
        ]);
    }
}
