<?php

namespace App\Http\Controllers;

use App\Actions\ListShopifyProductsAction;
use App\Actions\ListShopifyVariantsAction;
use App\Actions\UpdateShopifyVariantPriceActionByMaterial;
use App\Models\WizardContract;
use App\Service\ApiService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Inertia\Inertia;

class CreditCardController extends Controller
{
    //
    public function listContracts(Request $request)
    {

        $apiService = app(ApiService::class);
        $contracts = $apiService->get('/api/getCreditCardContracts', []);



        return Inertia::render('contracts', ["contracts" => $contracts]);
    }
    public function sendContract($id)
    {

        $apiService = app(ApiService::class);
        $apiService->post('/api/resendcontract/' . $id, ['via' => 'Email']);
        $apiService->post('/api/resendcontract/' . $id, ['via' => 'SMS']);

        $response = [
            'status' => 200,
            'message' => 'Contract sent',
            'data' => null,
        ];

        return response()->json($response, $response['status']);
    }

    public function getContracts()
    {

        $apiService = app(ApiService::class);
        $contracts = $apiService->get('/api/getCreditCardContracts', []);
        return response()->json(['contracts' => $contracts]);
    }
}
