<?php

namespace App\Helpers;

class PriceRoundingHelper
{
    /**
     * Apply rounding option to a price
     *
     * @param float $price
     * @param string $roundingOption
     * @param bool $skipHundredRound If true, for round_to_99_99 round to nearest integer then subtract 0.01 (used only in /price)
     * @return float
     */
    public static function applyRounding(float $price, string $roundingOption, bool $skipHundredRound = false): float
    {
        switch ($roundingOption) {
            case 'round_to_99_99':
                if ($skipHundredRound) {
                    // Round to nearest integer first, then subtract 0.01 to get .99 ending - used only in /price
                    // Example: 450.38 → round(450.38) = 450 → 450 - 0.01 = 449.99
                    $roundedToInteger = round($price);
                    return $roundedToInteger - 0.01;
                }
                // Round to nearest 100, then subtract 1 and add 0.99
                // Example: 1050 → 1100 → 1099.99
                $roundedToHundred = round($price / 100) * 100;
                return $roundedToHundred - 1 + 0.99;

            case 'round_to_hundreds':
                // Round up to nearest 100
                // Example: 5501 → 5600
                return ceil($price / 100) * 100;

            case 'round_to_hundreds_minus_one':
                // Round up to nearest 100, then subtract 1
                // Example: 5501 → 5600 → 5599
                $roundedToHundred = ceil($price / 100) * 100;
                return $roundedToHundred - 1;

            case 'default':
            default:
                // Default: round to nearest integer
                return round($price);
        }
    }
}
