<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // Fetch gold price twice a day: 5am and 5pm (New York time)
        $schedule->command('gold:fetch')
            ->dailyAt('07:18') // 
            ->timezone('America/New_York');

        $schedule->command('gold:fetch')
            ->dailyAt('14:50') // 
            ->timezone('America/New_York');

        $schedule->command('gold:fetch')
            ->dailyAt('17:50') // 
            ->timezone('America/New_York');

        // Auto-update gold prices twice a day at 7:20am and 3:00pm (New York time)
        // This runs after the gold fetch to ensure we have the latest price
        // withoutOverlapping() prevents multiple instances from running simultaneously
        // The timeout is set to 30 minutes (1800 seconds) to allow the job to complete
        $schedule->command('gold:auto-update-prices')
            ->dailyAt('07:20') // 7:20am EST
            ->timezone('America/New_York')
            ->withoutOverlapping(30); // Prevent overlapping executions for 30 minutes

        $schedule->command('gold:auto-update-prices')
            ->dailyAt('15:00') // 3:00pm EST
            ->timezone('America/New_York')
            ->withoutOverlapping(30); // Prevent overlapping executions for 30 minutes
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
