<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Cache;

class ReleaseGoldPriceLock extends Command
{
    protected $signature = 'gold:release-lock';

    protected $description = 'Libera el lock del job UpdateGoldPriceJob (útil si un run anterior crasheó sin soltarlo)';

    public function handle(): int
    {
        $lock = Cache::lock('update_gold_price_job', 10);
        $lock->forceRelease();

        $this->info('Listo. Si había lock bloqueado, ya está liberado. El próximo run de UpdateGoldPriceJob podrá ejecutarse.');
        return self::SUCCESS;
    }
}
