<?php

namespace App\Console\Commands;

use App\Actions\FetchGoldPriceAction;
use Illuminate\Console\Command;

class FetchGoldPrice extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'gold:fetch';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fetch and store the current gold price from Metal Price API';

    /**
     * Execute the console command.
     */
    public function handle(FetchGoldPriceAction $action)
    {
        try {
            $this->info('Fetching gold price from API...');

            $goldPrice = $action();

            $this->info("Gold price fetched and saved successfully!");
            $this->info("Price: $" . number_format($goldPrice->price, 2) . " per troy ounce");
            $this->info("Timestamp: " . $goldPrice->api_timestamp->format('Y-m-d H:i:s'));

            return 0;
        } catch (\Exception $e) {
            $this->error('❌ An error occurred:');
            $this->error('Message: ' . $e->getMessage());
            $this->error('File: ' . $e->getFile());
            $this->error('Line: ' . $e->getLine());

            if ($e->getPrevious()) {
                $this->error('Previous: ' . $e->getPrevious()->getMessage());
            }

            // Mostrar trace completo si está en modo debug
            if (config('app.debug')) {
                $this->error('Stack trace:');
                $this->line($e->getTraceAsString());
            }

            return 1;
        }
    }
}
